/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.geometry.fov;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.geometry.fov.AbstractFieldOfView;
import org.orekit.propagation.events.VisibilityTrigger;

public class PolygonalFieldOfView
extends AbstractFieldOfView {
    private final SphericalPolygonsSet zone;
    private final EnclosingBall<Sphere2D, S2Point> cap;

    public PolygonalFieldOfView(SphericalPolygonsSet zone, double margin) {
        super(margin);
        this.zone = zone;
        this.cap = zone.getEnclosingCap();
    }

    public PolygonalFieldOfView(Vector3D center, DefiningConeType coneType, Vector3D meridian, double radius, int n, double margin) {
        super(margin);
        double verticesRadius = coneType.verticesRadius(radius, n);
        Vector3D vertex = coneType.createVertex(center, meridian, verticesRadius, n);
        this.zone = new SphericalPolygonsSet(center, vertex, verticesRadius, n, 1.0E-12 * verticesRadius);
        Rotation r = new Rotation(center, Math.PI * 2 / (double)n, RotationConvention.VECTOR_OPERATOR);
        S2Point[] support = new S2Point[n];
        support[0] = new S2Point(vertex);
        for (int i = 1; i < n; ++i) {
            support[i] = new S2Point(r.applyTo(support[i - 1].getVector()));
        }
        this.cap = new EnclosingBall((Point)new S2Point(center), Vector3D.angle((Vector3D)center, (Vector3D)vertex), (Point[])support);
    }

    public SphericalPolygonsSet getZone() {
        return this.zone;
    }

    @Override
    public double offsetFromBoundary(Vector3D lineOfSight, double angularRadius, VisibilityTrigger trigger) {
        S2Point los = new S2Point(lineOfSight);
        double margin = this.getMargin();
        double correctedRadius = trigger.radiusCorrection(angularRadius);
        double deadBand = margin + angularRadius;
        double crudeDistance = ((S2Point)this.cap.getCenter()).distance((Point)los) - this.cap.getRadius();
        if (crudeDistance > deadBand + 0.01) {
            return crudeDistance + correctedRadius - margin;
        }
        return this.zone.projectToBoundary((Point)los).getOffset() + correctedRadius - margin;
    }

    @Override
    public Vector3D projectToBoundary(Vector3D lineOfSight) {
        return ((S2Point)this.zone.projectToBoundary((Point)new S2Point(lineOfSight)).getProjected()).getVector();
    }

    @Override
    public List<List<GeodeticPoint>> getFootprint(Transform fovToBody, OneAxisEllipsoid body, double angularStep) {
        Vector3D bodyCenter;
        Frame bodyFrame = body.getBodyFrame();
        Vector3D position = fovToBody.transformPosition(Vector3D.ZERO);
        double r = position.getNorm();
        if (body.isInside(position)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        ArrayList<List<GeodeticPoint>> footprint = new ArrayList<List<GeodeticPoint>>();
        List boundary = this.zone.getBoundaryLoops();
        for (Vertex loopStart : boundary) {
            int count = 0;
            ArrayList<GeodeticPoint> loop = new ArrayList<GeodeticPoint>();
            boolean intersectionsFound = false;
            Edge edge = loopStart.getOutgoing();
            while (count == 0 || edge.getStart() != loopStart) {
                ++count;
                int n = (int)FastMath.ceil((double)(edge.getLength() / angularStep));
                double delta = edge.getLength() / (double)n;
                for (int i = 0; i < n; ++i) {
                    Vector3D awaySC = new Vector3D(r, edge.getPointAt((double)i * delta));
                    Vector3D awayBody = fovToBody.transformPosition(awaySC);
                    Line lineOfSight = new Line(position, awayBody, 0.001);
                    GeodeticPoint gp = body.getIntersectionPoint(lineOfSight, position, bodyFrame, null);
                    if (gp != null && Vector3D.dotProduct((Vector3D)awayBody.subtract((Vector)position), (Vector3D)body.transform(gp).subtract((Vector)position)) < 0.0) {
                        gp = null;
                    }
                    if (gp != null) {
                        intersectionsFound = true;
                    } else {
                        gp = body.transform(body.pointOnLimb(position, awayBody), bodyFrame, null);
                    }
                    loop.add(0, gp);
                }
                edge = edge.getEnd().getOutgoing();
            }
            if (!intersectionsFound) continue;
            footprint.add(loop);
        }
        if (footprint.isEmpty() && this.zone.checkPoint((Point)new S2Point(bodyCenter = fovToBody.getStaticInverse().transformPosition(Vector3D.ZERO))) != Region.Location.OUTSIDE) {
            Vector3D x = bodyCenter.orthogonal();
            Vector3D y = (Vector3D)Vector3D.crossProduct((Vector3D)bodyCenter, (Vector3D)x).normalize();
            double sinEta = body.getEquatorialRadius() / r;
            double sinEta2 = sinEta * sinEta;
            double cosAlpha = (FastMath.cos((double)angularStep) + sinEta2 - 1.0) / sinEta2;
            int n = (int)FastMath.ceil((double)(Math.PI * 2 / FastMath.acos((double)cosAlpha)));
            double delta = Math.PI * 2 / (double)n;
            ArrayList<GeodeticPoint> loop = new ArrayList<GeodeticPoint>(n);
            for (int i = 0; i < n; ++i) {
                SinCos sc = FastMath.sinCos((double)((double)i * delta));
                Vector3D outside = new Vector3D(r * sc.cos(), x, r * sc.sin(), y);
                loop.add(body.transform(body.pointOnLimb(position, outside), bodyFrame, null));
            }
            footprint.add(loop);
        }
        return footprint;
    }

    public static enum DefiningConeType {
        INSIDE_CONE_TOUCHING_POLYGON_AT_EDGES_MIDDLE{

            @Override
            protected double verticesRadius(double radius, int n) {
                return FastMath.atan((double)(FastMath.tan((double)radius) / FastMath.cos((double)(Math.PI / (double)n))));
            }

            @Override
            protected Vector3D createVertex(Vector3D center, Vector3D meridian, double verticesRadius, int n) {
                SinCos scA = FastMath.sinCos((double)(Math.PI / (double)n));
                SinCos scR = FastMath.sinCos((double)verticesRadius);
                Vector3D z = (Vector3D)center.normalize();
                Vector3D y = (Vector3D)Vector3D.crossProduct((Vector3D)center, (Vector3D)meridian).normalize();
                Vector3D x = Vector3D.crossProduct((Vector3D)y, (Vector3D)z);
                return new Vector3D(scR.sin() * scA.cos(), x, scR.sin() * scA.sin(), y, scR.cos(), z);
            }
        }
        ,
        OUTSIDE_CONE_TOUCHING_POLYGON_AT_VERTICES{

            @Override
            protected double verticesRadius(double radius, int n) {
                return radius;
            }

            @Override
            protected Vector3D createVertex(Vector3D center, Vector3D meridian, double verticesRadius, int n) {
                SinCos scR = FastMath.sinCos((double)verticesRadius);
                Vector3D z = (Vector3D)center.normalize();
                Vector3D y = (Vector3D)Vector3D.crossProduct((Vector3D)center, (Vector3D)meridian).normalize();
                Vector3D x = Vector3D.crossProduct((Vector3D)y, (Vector3D)z);
                return new Vector3D(scR.sin(), x, scR.cos(), z);
            }
        };


        protected abstract double verticesRadius(double var1, int var3);

        protected abstract Vector3D createVertex(Vector3D var1, Vector3D var2, double var3, int var5);
    }
}

