/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames.encounter;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.encounter.AbstractEncounterLOF;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public class ValsecchiEncounterFrame
extends AbstractEncounterLOF {
    public ValsecchiEncounterFrame(PVCoordinates other) {
        super(other);
    }

    public <T extends CalculusFieldElement<T>> ValsecchiEncounterFrame(FieldPVCoordinates<T> other) {
        super(other);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> origin, FieldPVCoordinates<T> other) {
        FieldVector3D<T> otherVelocity = other.getVelocity();
        FieldVector3D xAxis = origin.getVelocity().crossProduct(otherVelocity).normalize();
        FieldVector3D yAxis = otherVelocity.subtract(origin.getVelocity()).normalize();
        return new FieldRotation(xAxis, yAxis, FieldVector3D.getPlusI(field), FieldVector3D.getPlusJ(field));
    }

    @Override
    public Rotation rotationFromInertial(PVCoordinates origin, PVCoordinates other) {
        Vector3D xAxis = (Vector3D)origin.getVelocity().crossProduct((Vector)other.getVelocity()).normalize();
        Vector3D yAxis = (Vector3D)other.getVelocity().subtract((Vector)origin.getVelocity()).normalize();
        return new Rotation(xAxis, yAxis, Vector3D.PLUS_I, Vector3D.PLUS_J);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getAxisNormalToCollisionPlane(Field<T> field) {
        return FieldVector3D.getPlusJ(field);
    }

    @Override
    public Vector3D getAxisNormalToCollisionPlane() {
        return Vector3D.PLUS_J;
    }

    @Override
    public String getName() {
        return "VALSECCHI_ENCOUNTER_LOF";
    }
}

