/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames.encounter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.MathArrays;
import org.orekit.frames.LOF;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public interface EncounterLOF
extends LOF {
    @Override
    default public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        return this.rotationFromInertial(field, pv);
    }

    @Override
    default public Rotation rotationFromInertial(AbsoluteDate date, PVCoordinates pv) {
        return this.rotationFromInertial(pv);
    }

    default public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> origin) {
        return this.rotationFromInertial(field, origin, this.getFieldOther(field));
    }

    default public Rotation rotationFromInertial(PVCoordinates origin) {
        return this.rotationFromInertial(origin, this.getOther());
    }

    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> var1, FieldPVCoordinates<T> var2, FieldPVCoordinates<T> var3);

    public Rotation rotationFromInertial(PVCoordinates var1, PVCoordinates var2);

    default public RealMatrix projectOntoCollisionPlane(RealMatrix matrix) {
        RealMatrix projectionMatrix = this.computeProjectionMatrix();
        return projectionMatrix.multiply(matrix.multiplyTransposed(projectionMatrix));
    }

    default public RealMatrix computeProjectionMatrix() {
        RealMatrix identity = MatrixUtils.createRealIdentityMatrix((int)3);
        List projectionMatrixDataList = Arrays.stream(identity.getData()).filter(values -> !Arrays.equals(values, this.getAxisNormalToCollisionPlane().toArray())).collect(Collectors.toList());
        double[][] projectionMatrixData = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            projectionMatrixData[i] = (double[])projectionMatrixDataList.get(i);
        }
        return new Array2DRowRealMatrix(projectionMatrixData);
    }

    default public <T extends CalculusFieldElement<T>> FieldMatrix<T> projectOntoCollisionPlane(FieldMatrix<T> matrix) {
        FieldMatrix<T> projectionMatrix = this.computeProjectionMatrix(matrix.getField());
        return projectionMatrix.multiply(matrix.multiplyTransposed(projectionMatrix));
    }

    default public <T extends CalculusFieldElement<T>> FieldMatrix<T> computeProjectionMatrix(Field<T> field) {
        FieldMatrix identity = MatrixUtils.createFieldIdentityMatrix(field, (int)3);
        List projectionMatrixDataList = Arrays.stream((CalculusFieldElement[][])identity.getData()).filter(values -> !Arrays.equals(values, this.getAxisNormalToCollisionPlane(field).toArray())).collect(Collectors.toList());
        CalculusFieldElement[][] projectionMatrixData = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)2, (int)3);
        for (int i = 0; i < 2; ++i) {
            projectionMatrixData[i] = (CalculusFieldElement[])projectionMatrixDataList.get(i);
        }
        return new Array2DRowFieldMatrix((FieldElement[][])projectionMatrixData);
    }

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getAxisNormalToCollisionPlane(Field<T> var1);

    default public Vector2D projectOntoCollisionPlane(Vector3D vector) {
        RealMatrix projectionMatrix = this.computeProjectionMatrix();
        Array2DRowRealMatrix vectorInMatrix = new Array2DRowRealMatrix(vector.toArray());
        return new Vector2D(projectionMatrix.multiply((RealMatrix)vectorInMatrix).getColumn(0));
    }

    default public <T extends CalculusFieldElement<T>> FieldVector2D<T> projectOntoCollisionPlane(FieldVector3D<T> vector) {
        FieldMatrix<T> projectionMatrix = this.computeProjectionMatrix(vector.getX().getField());
        Array2DRowFieldMatrix vectorInMatrix = new Array2DRowFieldMatrix((FieldElement[])vector.toArray());
        return new FieldVector2D((CalculusFieldElement[])projectionMatrix.multiply((FieldMatrix)vectorInMatrix).getColumn(0));
    }

    public <T extends CalculusFieldElement<T>> FieldPVCoordinates<T> getFieldOther(Field<T> var1);

    public Vector3D getAxisNormalToCollisionPlane();

    public PVCoordinates getOther();

    @Override
    default public boolean isQuasiInertial() {
        return true;
    }
}

