/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames.encounter;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.encounter.AbstractEncounterLOF;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public class DefaultEncounterLOF
extends AbstractEncounterLOF {
    public DefaultEncounterLOF(PVCoordinates other) {
        super(other);
    }

    public <T extends CalculusFieldElement<T>> DefaultEncounterLOF(FieldPVCoordinates<T> other) {
        super(other);
    }

    @Override
    public Rotation rotationFromInertial(PVCoordinates origin, PVCoordinates other) {
        Vector3D zAxis = (Vector3D)other.getVelocity().subtract((Vector)origin.getVelocity()).normalize();
        Vector3D yAxis = zAxis.crossProduct((Vector)other.getPosition().subtract((Vector)origin.getPosition()));
        return new Rotation(yAxis, zAxis, Vector3D.PLUS_J, Vector3D.PLUS_K);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getAxisNormalToCollisionPlane(Field<T> field) {
        return FieldVector3D.getPlusK(field);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> origin, FieldPVCoordinates<T> other) {
        FieldVector3D<T> otherVelocity = other.getVelocity();
        FieldVector3D<T> otherPosition = other.getPosition();
        FieldVector3D zAxis = otherVelocity.subtract(origin.getVelocity()).normalize();
        FieldVector3D yAxis = zAxis.crossProduct(otherPosition.subtract(origin.getPosition()));
        return new FieldRotation(yAxis, zAxis, FieldVector3D.getPlusJ(field), FieldVector3D.getPlusK(field));
    }

    @Override
    public Vector3D getAxisNormalToCollisionPlane() {
        return Vector3D.PLUS_K;
    }

    @Override
    public String getName() {
        return "DEFAULT_ENCOUNTER_LOF";
    }
}

