/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.ArrayList;
import java.util.List;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedGenerator;

public class TransformGenerator
implements TimeStampedGenerator<Transform> {
    private int neighborsSize;
    private final TransformProvider provider;
    private final double step;

    public TransformGenerator(int neighborsSize, TransformProvider provider, double step) {
        this.neighborsSize = neighborsSize;
        this.provider = provider;
        this.step = step;
    }

    @Override
    public List<Transform> generate(AbsoluteDate existingDate, AbsoluteDate date) {
        ArrayList<Transform> generated = new ArrayList<Transform>();
        if (existingDate == null) {
            for (int i = 0; i < this.neighborsSize; ++i) {
                generated.add(this.provider.getTransform(date.shiftedBy((double)i * this.step)));
            }
        } else {
            AbsoluteDate t = existingDate;
            if (date.compareTo(t) > 0) {
                do {
                    t = t.shiftedBy(this.step);
                    generated.add(generated.size(), this.provider.getTransform(t));
                } while (t.compareTo(date) <= 0);
            } else {
                do {
                    t = t.shiftedBy(-this.step);
                    generated.add(0, this.provider.getTransform(t));
                } while (t.compareTo(date) >= 0);
            }
        }
        return generated;
    }
}

