/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.TrackingCoordinates;

public class TopocentricFrame
extends Frame
implements PVCoordinatesProvider {
    private static final long serialVersionUID = -5997915708080966466L;
    private final BodyShape parentShape;
    private final GeodeticPoint point;
    private final Vector3D cartesianPoint;

    public TopocentricFrame(BodyShape parentShape, GeodeticPoint point, String name) {
        super(parentShape.getBodyFrame(), new Transform(AbsoluteDate.ARBITRARY_EPOCH, new Transform(AbsoluteDate.ARBITRARY_EPOCH, parentShape.transform(point).negate()), new Transform(AbsoluteDate.ARBITRARY_EPOCH, new Rotation(point.getEast(), point.getZenith(), Vector3D.PLUS_I, Vector3D.PLUS_K), Vector3D.ZERO)), name, false);
        this.parentShape = parentShape;
        this.point = point;
        this.cartesianPoint = this.getTransformProvider().getStaticTransform(AbsoluteDate.ARBITRARY_EPOCH).getInverse().transformPosition(Vector3D.ZERO);
    }

    public BodyShape getParentShape() {
        return this.parentShape;
    }

    public GeodeticPoint getPoint() {
        return this.point;
    }

    public Vector3D getCartesianPoint() {
        return this.cartesianPoint;
    }

    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> getPoint(Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        return new FieldGeodeticPoint<CalculusFieldElement>((CalculusFieldElement)zero.newInstance(this.point.getLatitude()), (CalculusFieldElement)zero.newInstance(this.point.getLongitude()), (CalculusFieldElement)zero.newInstance(this.point.getAltitude()));
    }

    public Vector3D getZenith() {
        return this.point.getZenith();
    }

    public Vector3D getNadir() {
        return this.point.getNadir();
    }

    public Vector3D getNorth() {
        return this.point.getNorth();
    }

    public Vector3D getSouth() {
        return this.point.getSouth();
    }

    public Vector3D getEast() {
        return this.point.getEast();
    }

    public Vector3D getWest() {
        return this.point.getWest();
    }

    public TrackingCoordinates getTrackingCoordinates(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Vector3D extPointTopo = this.transformPoint(extPoint, frame, date);
        double azimuth = this.computeAzimuthFromTopoPoint(extPointTopo);
        return new TrackingCoordinates(azimuth, extPointTopo.getDelta(), extPointTopo.getNorm());
    }

    public <T extends CalculusFieldElement<T>> FieldTrackingCoordinates<T> getTrackingCoordinates(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> extPointTopo = this.transformPoint(extPoint, frame, date);
        T azimuth = this.computeAzimuthFromTopoPoint(extPointTopo);
        return new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)azimuth, extPointTopo.getDelta(), extPointTopo.getNorm());
    }

    public double getElevation(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Vector3D extPointTopo = this.transformPoint(extPoint, frame, date);
        return extPointTopo.getDelta();
    }

    public <T extends CalculusFieldElement<T>> T getElevation(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> extPointTopo = this.transformPoint(extPoint, frame, date);
        return (T)extPointTopo.getDelta();
    }

    public double getAzimuth(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Vector3D extPointTopo = this.transformPoint(extPoint, frame, date);
        return this.computeAzimuthFromTopoPoint(extPointTopo);
    }

    public <T extends CalculusFieldElement<T>> T getAzimuth(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> extPointTopo = this.transformPoint(extPoint, frame, date);
        return this.computeAzimuthFromTopoPoint(extPointTopo);
    }

    public double getRange(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        Vector3D extPointTopo = this.transformPoint(extPoint, frame, date);
        return extPointTopo.getNorm();
    }

    public <T extends CalculusFieldElement<T>> T getRange(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> extPointTopo = this.transformPoint(extPoint, frame, date);
        return (T)extPointTopo.getNorm();
    }

    public double getRangeRate(PVCoordinates extPV, Frame frame, AbsoluteDate date) {
        KinematicTransform t = frame.getKinematicTransformTo((Frame)this, date);
        PVCoordinates extPVTopo = t.transformOnlyPV(extPV);
        return Vector3D.dotProduct((Vector3D)extPVTopo.getPosition(), (Vector3D)extPVTopo.getVelocity()) / extPVTopo.getPosition().getNorm();
    }

    public <T extends CalculusFieldElement<T>> T getRangeRate(FieldPVCoordinates<T> extPV, Frame frame, FieldAbsoluteDate<T> date) {
        FieldKinematicTransform<T> t = frame.getKinematicTransformTo((Frame)this, date);
        FieldPVCoordinates<T> extPVTopo = t.transformOnlyPV(extPV);
        return (T)((CalculusFieldElement)FieldVector3D.dotProduct(extPVTopo.getPosition(), extPVTopo.getVelocity()).divide((FieldElement)extPVTopo.getPosition().getNorm()));
    }

    public GeodeticPoint computeLimitVisibilityPoint(final double radius, final double azimuth, final double elevation) {
        try {
            double deltaP = 0.001;
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.567855942887398E-10, 0.001, 0.001, 5);
            double distance = solver.solve(1000, new UnivariateFunction(){

                public double value(double x) {
                    GeodeticPoint gp = TopocentricFrame.this.pointAtDistance(azimuth, elevation, x);
                    return TopocentricFrame.this.parentShape.transform(gp).getNorm() - radius;
                }
            }, 0.0, 2.0 * radius);
            return this.pointAtDistance(azimuth, elevation, distance);
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public GeodeticPoint pointAtDistance(double azimuth, double elevation, double distance) {
        SinCos scAz = FastMath.sinCos((double)azimuth);
        SinCos scEl = FastMath.sinCos((double)elevation);
        Vector3D observed = new Vector3D(distance * scEl.cos() * scAz.sin(), distance * scEl.cos() * scAz.cos(), distance * scEl.sin());
        return this.parentShape.transform(observed, (Frame)this, AbsoluteDate.ARBITRARY_EPOCH);
    }

    @Override
    public Vector3D getPosition(AbsoluteDate date, Frame frame) {
        return this.getStaticTransformTo(frame, date).transformPosition(Vector3D.ZERO);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.getTransformTo(frame, date).transformPVCoordinates(new TimeStampedPVCoordinates(date, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
    }

    public static Vector3D getTopocentricPosition(TrackingCoordinates coords) {
        return TopocentricFrame.getTopocentricPosition(coords.getAzimuth(), coords.getElevation(), coords.getRange());
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getTopocentricPosition(FieldTrackingCoordinates<T> coords) {
        return TopocentricFrame.getTopocentricPosition(coords.getAzimuth(), coords.getElevation(), coords.getRange());
    }

    private static Vector3D getTopocentricPosition(double azimuth, double elevation, double range) {
        SinCos sinCosAz = FastMath.sinCos((double)azimuth);
        SinCos sinCosEL = FastMath.sinCos((double)elevation);
        return new Vector3D(range * sinCosEL.cos() * sinCosAz.sin(), range * sinCosEL.cos() * sinCosAz.cos(), range * sinCosEL.sin());
    }

    private static <T extends CalculusFieldElement<T>> FieldVector3D<T> getTopocentricPosition(T azimuth, T elevation, T range) {
        FieldSinCos sinCosAz = FastMath.sinCos(azimuth);
        FieldSinCos sinCosEl = FastMath.sinCos(elevation);
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)range.multiply((FieldElement)((CalculusFieldElement)sinCosEl.cos()))).multiply((FieldElement)((CalculusFieldElement)sinCosAz.sin())), (CalculusFieldElement)((CalculusFieldElement)range.multiply((FieldElement)((CalculusFieldElement)sinCosEl.cos()))).multiply((FieldElement)((CalculusFieldElement)sinCosAz.cos())), (CalculusFieldElement)range.multiply((FieldElement)((CalculusFieldElement)sinCosEl.sin())));
    }

    private Vector3D transformPoint(Vector3D extPoint, Frame frame, AbsoluteDate date) {
        StaticTransform t = frame.getStaticTransformTo((Frame)this, date);
        return t.transformPosition(extPoint);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> transformPoint(FieldVector3D<T> extPoint, Frame frame, FieldAbsoluteDate<T> date) {
        FieldStaticTransform<T> t = frame.getStaticTransformTo((Frame)this, date);
        return t.transformPosition(extPoint);
    }

    private double computeAzimuthFromTopoPoint(Vector3D extPointTopo) {
        double azimuth = FastMath.atan2((double)extPointTopo.getX(), (double)extPointTopo.getY());
        if (azimuth < 0.0) {
            return azimuth + Math.PI * 2;
        }
        return azimuth;
    }

    private <T extends CalculusFieldElement<T>> T computeAzimuthFromTopoPoint(FieldVector3D<T> extPointTopo) {
        CalculusFieldElement azimuth = FastMath.atan2((CalculusFieldElement)extPointTopo.getX(), (CalculusFieldElement)extPointTopo.getY());
        if (azimuth.getReal() < 0.0) {
            return (T)((CalculusFieldElement)azimuth.add(Math.PI * 2));
        }
        return (T)azimuth;
    }
}

