/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScale;

class TIRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20130919L;
    private static final double AVE = 7.292115146706979E-5;
    private final EOPHistory eopHistory;
    private final transient TimeScale ut1;
    private final transient TimeScalarFunction era;

    protected TIRFProvider(EOPHistory eopHistory, TimeScale ut1) {
        this.ut1 = ut1;
        this.eopHistory = eopHistory;
        this.era = eopHistory.getConventions().getEarthOrientationAngleFunction(ut1, eopHistory.getTimeScales().getTAI());
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public TIRFProvider getNonInterpolatingProvider() {
        return new TIRFProvider(this.eopHistory.getEOPHistoryWithoutCachedTidalCorrection(), this.ut1);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        return new Transform(date, this.getRotation(date), this.getRotationRate(date));
    }

    @Override
    public KinematicTransform getKinematicTransform(AbsoluteDate date) {
        return KinematicTransform.of(date, this.getRotation(date), this.getRotationRate(date));
    }

    @Override
    public StaticTransform getStaticTransform(AbsoluteDate date) {
        return StaticTransform.of(date, this.getRotation(date));
    }

    private Rotation getRotation(AbsoluteDate date) {
        double correctedERA = this.era.value(date);
        return new Rotation(Vector3D.PLUS_K, correctedERA, RotationConvention.FRAME_TRANSFORM);
    }

    private Vector3D getRotationRate(AbsoluteDate date) {
        double lod = this.eopHistory == null ? 0.0 : this.eopHistory.getLOD(date);
        double omp = 7.292115146706979E-5 * (1.0 - lod / 86400.0);
        return new Vector3D(omp, Vector3D.PLUS_K);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        return new FieldTransform<T>(date, this.getRotation(date), this.getRotationRate(date));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> getKinematicTransform(FieldAbsoluteDate<T> date) {
        return FieldKinematicTransform.of(date, this.getRotation(date), this.getRotationRate(date));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldStaticTransform<T> getStaticTransform(FieldAbsoluteDate<T> date) {
        return FieldStaticTransform.of(date, this.getRotation(date));
    }

    private <T extends CalculusFieldElement<T>> FieldRotation<T> getRotation(FieldAbsoluteDate<T> date) {
        T correctedERA = this.era.value(date);
        return new FieldRotation(FieldVector3D.getPlusK(date.getField()), correctedERA, RotationConvention.FRAME_TRANSFORM);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getRotationRate(FieldAbsoluteDate<T> date) {
        Object lod = this.eopHistory == null ? (CalculusFieldElement)date.getField().getZero() : this.eopHistory.getLOD(date);
        CalculusFieldElement omp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)lod.divide(86400.0)).subtract(1.0)).multiply(-7.292115146706979E-5);
        return new FieldVector3D(omp, Vector3D.PLUS_K);
    }

    public double getEarthRotationAngle(AbsoluteDate date) {
        return MathUtils.normalizeAngle((double)this.era.value(date), (double)0.0);
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.eopHistory);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final EOPHistory eopHistory;

        DataTransferObject(EOPHistory eopHistory) {
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TIRFProvider(this.eopHistory, DataContext.getDefault().getTimeScales().getUT1(this.eopHistory));
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

