/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import java.util.function.ToDoubleFunction;
import org.hipparchus.util.FastMath;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistory;
import org.orekit.utils.SecularAndHarmonic;

public class SingleParameterFitter
implements Serializable {
    public static final double SUN_PULSATION = 1.991021277657232E-7;
    public static final double MOON_DRACONIC_PULSATION = 2.672404143948059E-6;
    private static final long serialVersionUID = 20230309L;
    private final double timeConstant;
    private final double convergence;
    private final int degree;
    private final double[] pulsations;

    @Deprecated
    public SingleParameterFitter(double fittingDuration, double timeConstant, double convergence, int degree, double ... pulsations) {
        this(timeConstant, convergence, degree, pulsations);
    }

    public SingleParameterFitter(double timeConstant, double convergence, int degree, double ... pulsations) {
        this.timeConstant = timeConstant;
        this.convergence = convergence;
        this.degree = degree;
        this.pulsations = (double[])pulsations.clone();
    }

    public SecularAndHarmonic fit(EOPHistory rawHistory, ToDoubleFunction<EOPEntry> extractor) {
        List<EOPEntry> rawEntries = rawHistory.getEntries();
        EOPEntry last = rawEntries.get(rawEntries.size() - 1);
        SecularAndHarmonic sh = new SecularAndHarmonic(this.degree, this.pulsations);
        sh.setConvergenceRMS(this.convergence);
        double[] initialGuess = new double[this.degree + 1 + 2 * this.pulsations.length];
        initialGuess[0] = extractor.applyAsDouble(last);
        sh.resetFitting(last.getDate(), initialGuess);
        ListIterator<EOPEntry> backwardIterator = rawEntries.listIterator(rawEntries.size());
        while (backwardIterator.hasPrevious()) {
            EOPEntry entry = backwardIterator.previous();
            sh.addWeightedPoint(entry.getDate(), extractor.applyAsDouble(entry), FastMath.exp((double)(entry.getDate().durationFrom(last.getDate()) / this.timeConstant)));
        }
        sh.fit();
        return sh;
    }

    public static SingleParameterFitter createDefaultDut1FitterShortTermPrediction() {
        return new SingleParameterFitter(518400.0, 1.0E-12, 3, 1.991021277657232E-7, 3.982042555314464E-7, 5.973063832971696E-7, 2.672404143948059E-6, 5.344808287896118E-6, 8.017212431844178E-6);
    }

    public static SingleParameterFitter createDefaultDut1FitterLongTermPrediction() {
        return new SingleParameterFitter(5184000.0, 1.0E-12, 3, 1.991021277657232E-7, 3.982042555314464E-7, 5.973063832971696E-7, 2.672404143948059E-6, 5.344808287896118E-6, 8.017212431844178E-6);
    }

    public static SingleParameterFitter createDefaultPoleFitterShortTermPrediction() {
        return new SingleParameterFitter(1036800.0, 1.0E-12, 3, 1.991021277657232E-7, 3.982042555314464E-7, 5.973063832971696E-7, 2.672404143948059E-6, 5.344808287896118E-6, 8.017212431844178E-6);
    }

    public static SingleParameterFitter createDefaultPoleFitterLongTermPrediction() {
        return new SingleParameterFitter(5184000.0, 1.0E-12, 3, 1.991021277657232E-7, 3.982042555314464E-7, 5.973063832971696E-7, 2.672404143948059E-6, 5.344808287896118E-6, 8.017212431844178E-6);
    }

    public static SingleParameterFitter createDefaultNutationFitterShortTermPrediction() {
        return new SingleParameterFitter(1036800.0, 1.0E-12, 3, 1.991021277657232E-7, 3.982042555314464E-7, 5.973063832971696E-7, 2.672404143948059E-6, 5.344808287896118E-6, 8.017212431844178E-6);
    }

    public static SingleParameterFitter createDefaultNutationFitterLongTermPrediction() {
        return new SingleParameterFitter(5184000.0, 1.0E-12, 3, 1.991021277657232E-7, 3.982042555314464E-7, 5.973063832971696E-7, 2.672404143948059E-6, 5.344808287896118E-6, 8.017212431844178E-6);
    }
}

