/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPFittedModel;
import org.orekit.frames.EOPFitter;
import org.orekit.frames.EOPHistory;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class PredictedEOPHistory
extends EOPHistory
implements Serializable {
    private static final long serialVersionUID = 20230309L;
    private final EOPHistory rawHistory;
    private final double extensionDuration;
    private final EOPFitter fitter;

    public PredictedEOPHistory(EOPHistory rawHistory, double extensionDuration, EOPFitter fitter) {
        super(rawHistory.getConventions(), rawHistory.getInterpolationDegree(), PredictedEOPHistory.extendHistory(rawHistory, extensionDuration, fitter), rawHistory.isSimpleEop(), rawHistory.getTimeScales());
        this.rawHistory = rawHistory;
        this.extensionDuration = extensionDuration;
        this.fitter = fitter;
    }

    private static Collection<? extends EOPEntry> extendHistory(EOPHistory rawHistory, double extensionDuration, EOPFitter fitter) {
        EOPFittedModel model = fitter.fit(rawHistory);
        IERSConventions.NutationCorrectionConverter converter = rawHistory.getConventions().getNutationCorrectionConverter(rawHistory.getTimeScales());
        List<EOPEntry> rawEntries = rawHistory.getEntries();
        EOPEntry last = rawEntries.get(rawEntries.size() - 1);
        int n = (int)FastMath.rint((double)(extensionDuration / 86400.0));
        ArrayList<EOPEntry> entries = new ArrayList<EOPEntry>(rawEntries.size() + n);
        entries.addAll(rawEntries);
        for (int i = 0; i < n; ++i) {
            AbsoluteDate date = last.getDate().shiftedBy((double)(i + 1) * 86400.0);
            double dut1 = model.getDUT1().osculatingValue(date);
            double lod = -86400.0 * model.getDUT1().osculatingDerivative(date);
            double xp = model.getXp().osculatingValue(date);
            double yp = model.getYp().osculatingValue(date);
            double xpRate = model.getXp().osculatingDerivative(date);
            double ypRate = model.getYp().osculatingDerivative(date);
            double dx = model.getDx().osculatingValue(date);
            double dy = model.getDy().osculatingValue(date);
            double[] equinox = converter.toEquinox(date, dx, dy);
            entries.add(new EOPEntry(last.getMjd() + i + 1, dut1, lod, xp, yp, xpRate, ypRate, equinox[0], equinox[1], dx, dy, last.getITRFType(), date));
        }
        return entries;
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.rawHistory, this.extensionDuration, this.fitter);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20230309L;
        private final EOPHistory rawHistory;
        private final double extensionDuration;
        private final EOPFitter fitter;

        DataTransferObject(EOPHistory rawHistory, double extensionDuration, EOPFitter fitter) {
            this.rawHistory = rawHistory;
            this.extensionDuration = extensionDuration;
            this.fitter = fitter;
        }

        private Object readResolve() {
            try {
                return new PredictedEOPHistory(this.rawHistory, this.extensionDuration, this.fitter);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

