/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOF;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class LocalOrbitalFrame
extends Frame {
    private static final long serialVersionUID = -4469440345574964950L;

    public LocalOrbitalFrame(Frame parent, LOF lof, PVCoordinatesProvider provider, String name) throws IllegalArgumentException {
        super(parent, new LocalProvider(lof, provider, parent), name, false);
    }

    private static class LocalProvider
    implements TransformProvider {
        private static final long serialVersionUID = 20170421L;
        private final LOF lof;
        private final PVCoordinatesProvider provider;
        private final Frame reference;

        LocalProvider(LOF lof, PVCoordinatesProvider provider, Frame reference) {
            this.lof = lof;
            this.provider = provider;
            this.reference = reference;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return this.lof.transformFromInertial(date, this.provider.getPVCoordinates(date, this.reference));
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(new OrekitException((Localizable)OrekitMessages.INTERNAL_ERROR, "https://forum.orekit.org"));
        }
    }
}

