/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.frames.LOF;
import org.orekit.frames.StaticTransform;
import org.orekit.models.earth.GeoMagneticField;
import org.orekit.models.earth.ReferenceEllipsoid;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public class LocalMagneticFieldFrame
implements LOF {
    private final Frame inertialFrame;
    private final LOFBuilderVector lofBuilderVector;
    private final OneAxisEllipsoid wgs84BodyShape;
    private final GeoMagneticField magneticField;

    public LocalMagneticFieldFrame(Frame inertialFrame, GeoMagneticField magneticField, Frame bodyFrame) {
        this(inertialFrame, magneticField, LOFBuilderVector.PLUS_MOMENTUM, bodyFrame);
    }

    public LocalMagneticFieldFrame(Frame inertialFrame, GeoMagneticField magneticField, LOFBuilderVector lofBuilderVector, Frame bodyFrame) {
        this.inertialFrame = inertialFrame;
        this.magneticField = magneticField;
        this.lofBuilderVector = lofBuilderVector;
        this.wgs84BodyShape = ReferenceEllipsoid.getWgs84(bodyFrame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        Rotation rotation = this.rotationFromInertial(date.toAbsoluteDate(), pv.toPVCoordinates());
        return new FieldRotation(field, rotation);
    }

    @Override
    public Rotation rotationFromInertial(AbsoluteDate date, PVCoordinates pv) {
        StaticTransform inertialToBodyFrame = this.inertialFrame.getStaticTransformTo(this.wgs84BodyShape.getBodyFrame(), date);
        Vector3D posBody = inertialToBodyFrame.transformPosition(pv.getPosition());
        double lat = posBody.getDelta();
        double lng = posBody.getAlpha();
        double alt = posBody.getNorm() - this.wgs84BodyShape.getEquatorialRadius();
        Vector3D magnVectorBody = this.magneticField.calculateField(lat, lng, alt).getFieldVector();
        StaticTransform bodyToInertialFrame = inertialToBodyFrame.getInverse();
        Vector3D magnVector = bodyToInertialFrame.transformVector(magnVectorBody);
        return new Rotation(magnVector, magnVector.crossProduct((Vector)this.lofBuilderVector.getVector(pv)), Vector3D.PLUS_I, Vector3D.PLUS_K);
    }

    @Override
    public String getName() {
        return "LOCAL_MAGNETIC_FIELD_FRAME";
    }

    public Frame getInertialFrame() {
        return this.inertialFrame;
    }

    public GeoMagneticField getMagneticField() {
        return this.magneticField;
    }

    public static enum LOFBuilderVector {
        PLUS_POSITION{

            @Override
            Vector3D getVector(PVCoordinates pv) {
                return pv.getPosition();
            }
        }
        ,
        PLUS_VELOCITY{

            @Override
            Vector3D getVector(PVCoordinates pv) {
                return pv.getVelocity();
            }
        }
        ,
        PLUS_MOMENTUM{

            @Override
            Vector3D getVector(PVCoordinates pv) {
                return pv.getMomentum();
            }
        }
        ,
        MINUS_POSITION{

            @Override
            Vector3D getVector(PVCoordinates pv) {
                return pv.getPosition().negate();
            }
        }
        ,
        MINUS_VELOCITY{

            @Override
            Vector3D getVector(PVCoordinates pv) {
                return pv.getVelocity().negate();
            }
        }
        ,
        MINUS_MOMENTUM{

            @Override
            Vector3D getVector(PVCoordinates pv) {
                return pv.getMomentum().negate();
            }
        };


        abstract Vector3D getVector(PVCoordinates var1);
    }
}

