/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.orekit.bodies.CelestialBodies;
import org.orekit.frames.AbstractFrames;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.EopHistoryLoader;
import org.orekit.frames.LazyLoadedEop;
import org.orekit.time.TimeScales;
import org.orekit.utils.IERSConventions;

public class LazyLoadedFrames
extends AbstractFrames {
    private final LazyLoadedEop lazyLoadedEop;

    public LazyLoadedFrames(LazyLoadedEop lazyLoadedEop, TimeScales timeScales, CelestialBodies celestialBodies) {
        super(timeScales, () -> celestialBodies.getSolarSystemBarycenter().getInertiallyOrientedFrame());
        this.lazyLoadedEop = lazyLoadedEop;
    }

    public void addDefaultEOP1980HistoryLoaders(String rapidDataColumnsSupportedNames, String xmlSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames, String csvSupportedNames) {
        this.lazyLoadedEop.addDefaultEOP1980HistoryLoaders(rapidDataColumnsSupportedNames, xmlSupportedNames, eopC04SupportedNames, bulletinBSupportedNames, bulletinASupportedNames, csvSupportedNames, () -> this.getTimeScales().getUTC());
    }

    public void addDefaultEOP2000HistoryLoaders(String rapidDataColumnsSupportedNames, String xmlSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames, String csvSupportedNames) {
        this.lazyLoadedEop.addDefaultEOP2000HistoryLoaders(rapidDataColumnsSupportedNames, xmlSupportedNames, eopC04SupportedNames, bulletinBSupportedNames, bulletinASupportedNames, csvSupportedNames, () -> this.getTimeScales().getUTC());
    }

    public void addEOPHistoryLoader(IERSConventions conventions, EopHistoryLoader loader) {
        this.lazyLoadedEop.addEOPHistoryLoader(conventions, loader);
    }

    public void clearEOPHistoryLoaders() {
        this.lazyLoadedEop.clearEOPHistoryLoaders();
    }

    public void setEOPContinuityThreshold(double threshold) {
        this.lazyLoadedEop.setEOPContinuityThreshold(threshold);
    }

    @Override
    public EOPHistory getEOPHistory(IERSConventions conventions, boolean simpleEOP) {
        return this.lazyLoadedEop.getEOPHistory(conventions, simpleEOP, this.getTimeScales());
    }
}

