/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.frames.BulletinAFilesLoader;
import org.orekit.frames.BulletinBFilesLoader;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.EopC04FilesLoader;
import org.orekit.frames.EopCsvFilesLoader;
import org.orekit.frames.EopHistoryLoader;
import org.orekit.frames.EopXmlLoader;
import org.orekit.frames.RapidDataAndPredictionColumnsLoader;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeStamped;
import org.orekit.utils.IERSConventions;

public class LazyLoadedEop {
    private final DataProvidersManager dataProvidersManager;
    private final Map<IERSConventions, List<EopHistoryLoader>> eopHistoryLoaders;
    private double eopContinuityThreshold;
    private int interpolationDegree;

    public LazyLoadedEop(DataProvidersManager dataProvidersManager) {
        this.dataProvidersManager = dataProvidersManager;
        this.eopHistoryLoaders = new HashMap<IERSConventions, List<EopHistoryLoader>>();
        this.eopContinuityThreshold = 432000.0;
        this.interpolationDegree = 3;
    }

    public DataProvidersManager getDataProvidersManager() {
        return this.dataProvidersManager;
    }

    public void addDefaultEOP1980HistoryLoaders(String rapidDataColumnsSupportedNames, String xmlSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames, String csvSupportedNames, Supplier<TimeScale> utcSupplier) {
        String rapidColNames = rapidDataColumnsSupportedNames == null ? "^finals\\.[^.]*$" : rapidDataColumnsSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_1996, new RapidDataAndPredictionColumnsLoader(false, rapidColNames, this.dataProvidersManager, utcSupplier));
        String xmlNames = xmlSupportedNames == null ? "^(:finals|eopc04_\\d\\d)\\..*\\.xml$" : xmlSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_1996, new EopXmlLoader(xmlNames, this.dataProvidersManager, utcSupplier));
        String eopcNames = eopC04SupportedNames == null ? "^eopc04(_\\d\\d)?\\.\\d\\d$" : eopC04SupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_1996, new EopC04FilesLoader(eopcNames, this.dataProvidersManager, utcSupplier));
        String bulBNames = bulletinBSupportedNames == null ? "^bulletinb(_IAU1980)?((-\\d\\d\\d\\.txt)|(\\.\\d\\d\\d))$" : bulletinBSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_1996, new BulletinBFilesLoader(bulBNames, this.dataProvidersManager, utcSupplier));
        String bulANames = bulletinASupportedNames == null ? "^bulletina-[ivxlcdm]+-\\d\\d\\d\\.txt$" : bulletinASupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_1996, new BulletinAFilesLoader(bulANames, this.dataProvidersManager, utcSupplier));
        String csvNames = csvSupportedNames == null ? "^(?:eopc04|bulletina|bulletinb).*\\.csv$" : csvSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_1996, new EopCsvFilesLoader(csvNames, this.dataProvidersManager, utcSupplier));
    }

    public void addDefaultEOP2000HistoryLoaders(String rapidDataColumnsSupportedNames, String xmlSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames, String csvSupportedNames, Supplier<TimeScale> utcSupplier) {
        String rapidColNames = rapidDataColumnsSupportedNames == null ? "^finals2000A\\.[^.]*$" : rapidDataColumnsSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_2003, new RapidDataAndPredictionColumnsLoader(true, rapidColNames, this.dataProvidersManager, utcSupplier));
        this.addEOPHistoryLoader(IERSConventions.IERS_2010, new RapidDataAndPredictionColumnsLoader(true, rapidColNames, this.dataProvidersManager, utcSupplier));
        String xmlNames = xmlSupportedNames == null ? "^(:finals2000A|eopc04_\\d\\d_IAU2000)\\..*\\.xml$" : xmlSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_2003, new EopXmlLoader(xmlNames, this.dataProvidersManager, utcSupplier));
        this.addEOPHistoryLoader(IERSConventions.IERS_2010, new EopXmlLoader(xmlNames, this.dataProvidersManager, utcSupplier));
        String eopcNames = eopC04SupportedNames == null ? "^eopc04(_\\d\\d_IAU2000)?\\.\\d\\d$" : eopC04SupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_2003, new EopC04FilesLoader(eopcNames, this.dataProvidersManager, utcSupplier));
        this.addEOPHistoryLoader(IERSConventions.IERS_2010, new EopC04FilesLoader(eopcNames, this.dataProvidersManager, utcSupplier));
        String bulBNames = bulletinBSupportedNames == null ? "^bulletinb(_IAU2000)?((-\\d\\d\\d\\.txt)|(\\.\\d\\d\\d))$" : bulletinBSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_2003, new BulletinBFilesLoader(bulBNames, this.dataProvidersManager, utcSupplier));
        this.addEOPHistoryLoader(IERSConventions.IERS_2010, new BulletinBFilesLoader(bulBNames, this.dataProvidersManager, utcSupplier));
        String bulANames = bulletinASupportedNames == null ? "^bulletina-[ivxlcdm]+-\\d\\d\\d\\.txt$" : bulletinASupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_2003, new BulletinAFilesLoader(bulANames, this.dataProvidersManager, utcSupplier));
        this.addEOPHistoryLoader(IERSConventions.IERS_2010, new BulletinAFilesLoader(bulANames, this.dataProvidersManager, utcSupplier));
        String csvNames = csvSupportedNames == null ? "^(?:eopc04|bulletina|bulletinb).*\\.csv$" : csvSupportedNames;
        this.addEOPHistoryLoader(IERSConventions.IERS_2003, new EopCsvFilesLoader(csvNames, this.dataProvidersManager, utcSupplier));
        this.addEOPHistoryLoader(IERSConventions.IERS_2010, new EopCsvFilesLoader(csvNames, this.dataProvidersManager, utcSupplier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEOPHistoryLoader(IERSConventions conventions, EopHistoryLoader loader) {
        Map<IERSConventions, List<EopHistoryLoader>> map = this.eopHistoryLoaders;
        synchronized (map) {
            if (!this.eopHistoryLoaders.containsKey((Object)conventions)) {
                this.eopHistoryLoaders.put(conventions, new ArrayList());
            }
            this.eopHistoryLoaders.get((Object)conventions).add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEOPHistoryLoaders() {
        Map<IERSConventions, List<EopHistoryLoader>> map = this.eopHistoryLoaders;
        synchronized (map) {
            this.eopHistoryLoaders.clear();
        }
    }

    public void setEOPContinuityThreshold(double threshold) {
        this.eopContinuityThreshold = threshold;
    }

    public void setInterpolationDegree(int interpolationDegree) {
        this.interpolationDegree = interpolationDegree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOPHistory getEOPHistory(IERSConventions conventions, boolean simpleEOP, TimeScales timeScales) {
        Map<IERSConventions, List<EopHistoryLoader>> map = this.eopHistoryLoaders;
        synchronized (map) {
            if (this.eopHistoryLoaders.isEmpty()) {
                Supplier<TimeScale> utcSupplier = timeScales::getUTC;
                this.addDefaultEOP2000HistoryLoaders(null, null, null, null, null, null, utcSupplier);
                this.addDefaultEOP1980HistoryLoaders(null, null, null, null, null, null, utcSupplier);
            }
            OrekitException pendingException = null;
            TreeSet<TimeStamped> data = new TreeSet<TimeStamped>(new ChronologicalComparator());
            if (this.eopHistoryLoaders.containsKey((Object)conventions)) {
                for (EopHistoryLoader loader : this.eopHistoryLoaders.get((Object)conventions)) {
                    try {
                        loader.fillHistory(conventions.getNutationCorrectionConverter(timeScales), data);
                    }
                    catch (OrekitException oe) {
                        pendingException = oe;
                    }
                }
            }
            if (data.isEmpty() && pendingException != null) {
                throw pendingException;
            }
            EOPHistory history = new EOPHistory(conventions, this.interpolationDegree, data, simpleEOP, timeScales);
            history.checkEOPContinuity(this.eopContinuityThreshold);
            return history;
        }
    }
}

