/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.frames.LOF;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public enum LOFType implements LOF
{
    TNW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getVelocity(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.TNW;
        }
    }
    ,
    TNW_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return TNW.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return TNW.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.TNW_INERTIAL;
        }
    }
    ,
    QSW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getPosition(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.QSW;
        }
    }
    ,
    QSW_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return QSW.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return QSW.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.RSW_INERTIAL;
        }
    }
    ,
    LVLH{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getPosition(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DIFFERENT_LVLH_DEFINITION, new Object[0]);
        }
    }
    ,
    LVLH_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return LVLH.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return LVLH.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DIFFERENT_LVLH_DEFINITION, new Object[0]);
        }
    }
    ,
    LVLH_CCSDS{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.MINUS_K, Vector3D.MINUS_J);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getPosition(), pv.getMomentum(), new FieldVector3D(field, Vector3D.MINUS_K), new FieldVector3D(field, Vector3D.MINUS_J));
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.LVLH;
        }
    }
    ,
    LVLH_CCSDS_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return LVLH_CCSDS.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return LVLH_CCSDS.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.LVLH_INERTIAL;
        }
    }
    ,
    VVLH{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return LVLH_CCSDS.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return LVLH_CCSDS.rotationFromInertial(field, pv);
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.LVLH;
        }
    }
    ,
    VVLH_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return VVLH.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return VVLH.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.LVLH_INERTIAL;
        }
    }
    ,
    VNC{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_J);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getVelocity(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_J));
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.VNC_ROTATING;
        }
    }
    ,
    VNC_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return VNC.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return VNC.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.VNC_INERTIAL;
        }
    }
    ,
    EQW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            Vector3D m = pv.getMomentum();
            return new Rotation(new Vector3D(-m.getY(), m.getX(), 0.0), m, Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            FieldVector3D<T> m = pv.getMomentum();
            return new FieldRotation(new FieldVector3D((CalculusFieldElement)m.getY().negate(), m.getX(), (CalculusFieldElement)field.getZero()), m, new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.EQW_INERTIAL;
        }
    }
    ,
    NTW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_J, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getVelocity(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_J), new FieldVector3D(field, Vector3D.PLUS_K));
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.NTW_ROTATING;
        }
    }
    ,
    NTW_INERTIAL{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return NTW.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return NTW.rotationFromInertial(field, pv);
        }

        @Override
        public boolean isQuasiInertial() {
            return true;
        }

        @Override
        public OrbitRelativeFrame toOrbitRelativeFrame() {
            return OrbitRelativeFrame.NTW_INERTIAL;
        }
    };


    @Override
    public String getName() {
        return this.name();
    }

    static Rotation rotationFromLOFInToLOFOut(LOFType in, LOFType out, PVCoordinates pv) {
        return out.rotationFromLOF(in, pv);
    }

    static <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromLOFInToLOFOut(Field<T> field, LOFType in, LOFType out, FieldPVCoordinates<T> pv) {
        return out.rotationFromLOF(field, in, pv);
    }

    public Rotation rotationFromLOF(LOFType fromLOF, PVCoordinates pv) {
        Rotation fromLOFToInertial = fromLOF.rotationFromInertial(pv).revert();
        Rotation inertialToThis = this.rotationFromInertial(pv);
        return fromLOFToInertial.compose(inertialToThis, RotationConvention.FRAME_TRANSFORM);
    }

    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromLOF(Field<T> field, LOFType fromLOF, FieldPVCoordinates<T> pv) {
        FieldRotation fromLOFToInertial = fromLOF.rotationFromInertial(field, pv).revert();
        FieldRotation<T> inertialToThis = this.rotationFromInertial(field, pv);
        return fromLOFToInertial.compose(inertialToThis, RotationConvention.FRAME_TRANSFORM);
    }

    @Override
    public Rotation rotationFromInertial(AbsoluteDate date, PVCoordinates pv) {
        return this.rotationFromInertial(pv);
    }

    public abstract Rotation rotationFromInertial(PVCoordinates var1);

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        return this.rotationFromInertial(field, pv);
    }

    public abstract <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> var1, FieldPVCoordinates<T> var2);

    public abstract OrbitRelativeFrame toOrbitRelativeFrame();
}

