/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public interface LOF {
    public static <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromLOFInToLOFOut(Field<T> field, LOF in, LOF out, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        return out.rotationFromLOF(field, in, date, pv);
    }

    public static <T extends CalculusFieldElement<T>> FieldTransform<T> transformFromLOFInToLOFOut(LOF in, LOF out, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        return out.transformFromLOF(in, date, pv);
    }

    public static Rotation rotationFromLOFInToLOFOut(LOF in, LOF out, AbsoluteDate date, PVCoordinates pv) {
        return out.rotationFromLOF(in, date, pv);
    }

    public static Transform transformFromLOFInToLOFOut(LOF in, LOF out, AbsoluteDate date, PVCoordinates pv) {
        return out.transformFromLOF(in, date, pv);
    }

    default public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromLOF(Field<T> field, LOF fromLOF, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        FieldRotation fromLOFToInertial = fromLOF.rotationFromInertial(field, date, pv).revert();
        FieldRotation<T> inertialToThis = this.rotationFromInertial(field, date, pv);
        return fromLOFToInertial.compose(inertialToThis, RotationConvention.FRAME_TRANSFORM);
    }

    default public <T extends CalculusFieldElement<T>> FieldTransform<T> transformFromLOF(LOF fromLOF, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        FieldKinematicTransform fromLOFToInertial = fromLOF.transformFromInertial(date, pv).getInverse();
        FieldTransform<T> inertialToLOFOut = this.transformFromInertial(date, pv);
        return new FieldTransform<T>(date, fromLOFToInertial, inertialToLOFOut);
    }

    default public <T extends CalculusFieldElement<T>> FieldTransform<T> transformFromInertial(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        if (this.isQuasiInertial()) {
            Field<T> field = date.getField();
            return new FieldTransform<T>(date, pv.getPosition().negate(), this.rotationFromInertial(field, date, pv));
        }
        FieldTransform<T> translation = new FieldTransform<T>(date, pv.negate());
        FieldRotation<T> r = this.rotationFromInertial(date.getField(), date, pv);
        FieldVector3D<T> p = pv.getPosition();
        FieldVector3D<T> momentum = pv.getMomentum();
        FieldTransform<T> rotation = new FieldTransform<T>(date, r, new FieldVector3D((CalculusFieldElement)p.getNormSq().reciprocal(), r.applyTo(momentum)));
        return new FieldTransform<T>(date, translation, rotation);
    }

    public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> var1, FieldAbsoluteDate<T> var2, FieldPVCoordinates<T> var3);

    default public Rotation rotationFromLOF(LOF fromLOF, AbsoluteDate date, PVCoordinates pv) {
        Rotation fromLOFToInertial = fromLOF.rotationFromInertial(date, pv).revert();
        Rotation inertialToThis = this.rotationFromInertial(date, pv);
        return fromLOFToInertial.compose(inertialToThis, RotationConvention.FRAME_TRANSFORM);
    }

    default public Transform transformFromLOF(LOF fromLOF, AbsoluteDate date, PVCoordinates pv) {
        Transform fromLOFToInertial = fromLOF.transformFromInertial(date, pv).getInverse();
        Transform inertialToThis = this.transformFromInertial(date, pv);
        return new Transform(date, fromLOFToInertial, inertialToThis);
    }

    default public Transform transformFromInertial(AbsoluteDate date, PVCoordinates pv) {
        if (this.isQuasiInertial()) {
            return new Transform(date, pv.getPosition().negate(), this.rotationFromInertial(date, pv));
        }
        Rotation r = this.rotationFromInertial(date, pv);
        Vector3D p = pv.getPosition();
        Vector3D momentum = pv.getMomentum();
        AngularCoordinates angularCoordinates = new AngularCoordinates(r, new Vector3D(1.0 / p.getNormSq(), r.applyTo(momentum)));
        return new Transform(date, pv.negate(), angularCoordinates);
    }

    public Rotation rotationFromInertial(AbsoluteDate var1, PVCoordinates var2);

    default public boolean isQuasiInertial() {
        return false;
    }

    public String getName();
}

