/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.Arrays;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public interface KinematicTransform
extends StaticTransform {
    public static KinematicTransform getIdentity() {
        return Transform.IDENTITY;
    }

    public static Vector3D compositeVelocity(KinematicTransform first, KinematicTransform second) {
        Vector3D v1 = first.getVelocity();
        Rotation r1 = first.getRotation();
        Vector3D o1 = first.getRotationRate();
        Vector3D p2 = second.getTranslation();
        Vector3D v2 = second.getVelocity();
        Vector3D crossP = Vector3D.crossProduct((Vector3D)o1, (Vector3D)p2);
        return v1.add((Vector)r1.applyInverseTo(v2.add((Vector)crossP)));
    }

    public static Vector3D compositeRotationRate(KinematicTransform first, KinematicTransform second) {
        Vector3D o1 = first.getRotationRate();
        Rotation r2 = second.getRotation();
        Vector3D o2 = second.getRotationRate();
        return o2.add((Vector)r2.applyTo(o1));
    }

    default public PVCoordinates transformOnlyPV(PVCoordinates pv) {
        Vector3D transformedP = this.transformPosition(pv.getPosition());
        Vector3D crossP = Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)transformedP);
        Vector3D transformedV = this.getRotation().applyTo(pv.getVelocity().add((Vector)this.getVelocity())).subtract((Vector)crossP);
        return new PVCoordinates(transformedP, transformedV);
    }

    default public TimeStampedPVCoordinates transformOnlyPV(TimeStampedPVCoordinates pv) {
        Vector3D transformedP = this.transformPosition(pv.getPosition());
        Vector3D crossP = Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)transformedP);
        Vector3D transformedV = this.getRotation().applyTo(pv.getVelocity().add((Vector)this.getVelocity())).subtract((Vector)crossP);
        return new TimeStampedPVCoordinates(pv.getDate(), transformedP, transformedV);
    }

    default public double[][] getPVJacobian() {
        double[][] jacobian = new double[6][6];
        double[][] mData = this.getRotation().getMatrix();
        System.arraycopy(mData[0], 0, jacobian[0], 0, 3);
        System.arraycopy(mData[1], 0, jacobian[1], 0, 3);
        System.arraycopy(mData[2], 0, jacobian[2], 0, 3);
        Arrays.fill(jacobian[0], 3, 6, 0.0);
        Arrays.fill(jacobian[1], 3, 6, 0.0);
        Arrays.fill(jacobian[2], 3, 6, 0.0);
        Vector3D o = this.getRotationRate();
        double ox = o.getX();
        double oy = o.getY();
        double oz = o.getZ();
        for (int i = 0; i < 3; ++i) {
            jacobian[3][i] = -(oy * mData[2][i] - oz * mData[1][i]);
            jacobian[4][i] = -(oz * mData[0][i] - ox * mData[2][i]);
            jacobian[5][i] = -(ox * mData[1][i] - oy * mData[0][i]);
        }
        System.arraycopy(mData[0], 0, jacobian[3], 3, 3);
        System.arraycopy(mData[1], 0, jacobian[4], 3, 3);
        System.arraycopy(mData[2], 0, jacobian[5], 3, 3);
        return jacobian;
    }

    public Vector3D getVelocity();

    public Vector3D getRotationRate();

    @Override
    public KinematicTransform getInverse();

    public static KinematicTransform compose(AbsoluteDate date, KinematicTransform first, KinematicTransform second) {
        Vector3D composedTranslation = StaticTransform.compositeTranslation(first, second);
        Vector3D composedTranslationRate = KinematicTransform.compositeVelocity(first, second);
        return KinematicTransform.of(date, new PVCoordinates(composedTranslation, composedTranslationRate), StaticTransform.compositeRotation(first, second), KinematicTransform.compositeRotationRate(first, second));
    }

    public static KinematicTransform of(AbsoluteDate date, Rotation rotation, Vector3D rotationRate) {
        return KinematicTransform.of(date, PVCoordinates.ZERO, rotation, rotationRate);
    }

    public static KinematicTransform of(AbsoluteDate date, PVCoordinates pvCoordinates) {
        return KinematicTransform.of(date, pvCoordinates, Rotation.IDENTITY, Vector3D.ZERO);
    }

    public static KinematicTransform of(final AbsoluteDate date, final PVCoordinates pvCoordinates, final Rotation rotation, final Vector3D rotationRate) {
        return new KinematicTransform(){

            @Override
            public KinematicTransform getInverse() {
                Rotation r = this.getRotation();
                Vector3D rp = r.applyTo(this.getTranslation());
                Vector3D pInv = rp.negate();
                Vector3D crossP = Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)rp);
                Vector3D vInv = crossP.subtract((Vector)this.getRotation().applyTo(this.getVelocity()));
                Rotation rInv = r.revert();
                return KinematicTransform.of(this.getDate(), new PVCoordinates(pInv, vInv), rInv, rInv.applyTo(this.getRotationRate()).negate());
            }

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public Vector3D getTranslation() {
                return pvCoordinates.getPosition();
            }

            @Override
            public Rotation getRotation() {
                return rotation;
            }

            @Override
            public Vector3D getVelocity() {
                return pvCoordinates.getVelocity();
            }

            @Override
            public Vector3D getRotationRate() {
                return rotationRate;
            }
        };
    }
}

