/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldPoleCorrection;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.PoleCorrection;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

class ITRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20130922L;
    private static final double S_PRIME_RATE = -2.278624301214819E-10;
    private final EOPHistory eopHistory;

    ITRFProvider(EOPHistory eopHistory) {
        this.eopHistory = eopHistory;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public ITRFProvider getNonInterpolatingProvider() {
        return new ITRFProvider(this.eopHistory.getEOPHistoryWithoutCachedTidalCorrection());
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double tts = date.durationFrom(this.eopHistory.getTimeScales().getJ2000Epoch());
        double ttc = tts / 3.15576E9;
        PoleCorrection eop = this.eopHistory.getPoleCorrection(date);
        Rotation wRot = new Rotation(RotationOrder.XYZ, RotationConvention.FRAME_TRANSFORM, eop.getYp(), eop.getXp(), 2.278624301214819E-10 * ttc);
        Rotation combined = wRot.revert();
        return new Transform(date, combined, Vector3D.ZERO);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T tts = date.durationFrom(this.eopHistory.getTimeScales().getJ2000Epoch());
        CalculusFieldElement ttc = (CalculusFieldElement)tts.divide(3.15576E9);
        FieldPoleCorrection<T> eop = this.eopHistory.getPoleCorrection(date);
        FieldRotation wRot = new FieldRotation(RotationOrder.XYZ, RotationConvention.FRAME_TRANSFORM, eop.getYp(), eop.getXp(), (CalculusFieldElement)ttc.multiply(2.278624301214819E-10));
        FieldRotation combined = wRot.revert();
        return new FieldTransform<T>(date, combined, FieldVector3D.getZero(date.getField()));
    }
}

