/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hipparchus.CalculusFieldElement;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.FixedTransformProvider;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.Predefined;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class Frame
implements Serializable {
    private static final long serialVersionUID = -6981146543760234087L;
    private final Frame parent;
    private final int depth;
    private final TransformProvider transformProvider;
    private final String name;
    private final boolean pseudoInertial;

    private Frame(String name, boolean pseudoInertial) {
        this.parent = null;
        this.depth = 0;
        this.transformProvider = new FixedTransformProvider(Transform.IDENTITY);
        this.name = name;
        this.pseudoInertial = pseudoInertial;
    }

    public Frame(Frame parent, Transform transform, String name) throws IllegalArgumentException {
        this(parent, transform, name, false);
    }

    public Frame(Frame parent, TransformProvider transformProvider, String name) throws IllegalArgumentException {
        this(parent, transformProvider, name, false);
    }

    public Frame(Frame parent, Transform transform, String name, boolean pseudoInertial) throws IllegalArgumentException {
        this(parent, new FixedTransformProvider(transform), name, pseudoInertial);
    }

    public Frame(Frame parent, TransformProvider transformProvider, String name, boolean pseudoInertial) throws IllegalArgumentException {
        if (parent == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_PARENT_FOR_FRAME, name);
        }
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.transformProvider = transformProvider;
        this.name = name;
        this.pseudoInertial = pseudoInertial;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPseudoInertial() {
        return this.pseudoInertial;
    }

    public String toString() {
        return this.name;
    }

    public Frame getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public Frame getAncestor(int n) throws IllegalArgumentException {
        if (n > this.depth) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAME_NO_NTH_ANCESTOR, this.name, this.depth, n);
        }
        Frame current = this;
        for (int i = 0; i < n; ++i) {
            current = current.parent;
        }
        return current;
    }

    public Transform getTransformTo(Frame destination, AbsoluteDate date) {
        return this.getTransformTo(destination, Transform.IDENTITY, frame -> frame.getTransformProvider().getTransform(date), (t1, t2) -> new Transform(date, (Transform)t1, (Transform)t2), Transform::getInverse);
    }

    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransformTo(Frame destination, FieldAbsoluteDate<T> date) {
        return this.getTransformTo(destination, FieldTransform.getIdentity(date.getField()), frame -> frame.getTransformProvider().getTransform(date), (t1, t2) -> new FieldTransform(date, t1, t2), FieldTransform::getInverse);
    }

    public KinematicTransform getKinematicTransformTo(Frame destination, AbsoluteDate date) {
        return this.getTransformTo(destination, KinematicTransform.getIdentity(), frame -> frame.getTransformProvider().getKinematicTransform(date), (t1, t2) -> KinematicTransform.compose(date, t1, t2), KinematicTransform::getInverse);
    }

    public StaticTransform getStaticTransformTo(Frame destination, AbsoluteDate date) {
        return this.getTransformTo(destination, StaticTransform.getIdentity(), frame -> frame.getTransformProvider().getStaticTransform(date), (t1, t2) -> StaticTransform.compose(date, t1, t2), StaticTransform::getInverse);
    }

    public <T extends CalculusFieldElement<T>> FieldStaticTransform<T> getStaticTransformTo(Frame destination, FieldAbsoluteDate<T> date) {
        if (date.hasZeroField()) {
            return FieldStaticTransform.of(date, this.getStaticTransformTo(destination, date.toAbsoluteDate()));
        }
        return this.getTransformTo(destination, FieldStaticTransform.getIdentity(date.getField()), frame -> frame.getTransformProvider().getStaticTransform(date), (t1, t2) -> FieldStaticTransform.compose(date, t1, t2), FieldStaticTransform::getInverse);
    }

    public <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> getKinematicTransformTo(Frame destination, FieldAbsoluteDate<T> date) {
        if (date.hasZeroField()) {
            KinematicTransform kinematicTransform = this.getKinematicTransformTo(destination, date.toAbsoluteDate());
            return FieldKinematicTransform.of(date.getField(), kinematicTransform);
        }
        return this.getTransformTo(destination, FieldKinematicTransform.getIdentity(date.getField()), frame -> frame.getTransformProvider().getKinematicTransform(date), (t1, t2) -> FieldKinematicTransform.compose(date, t1, t2), FieldKinematicTransform::getInverse);
    }

    private <T> T getTransformTo(Frame destination, T identity, Function<Frame, T> getTransform, BiFunction<T, T, T> compose, Function<T, T> inverse) {
        if (this == destination) {
            return identity;
        }
        Frame common = Frame.findCommon(this, destination);
        T commonToInstance = identity;
        Frame frame = this;
        while (frame != common) {
            commonToInstance = compose.apply(getTransform.apply(frame), commonToInstance);
            frame = frame.parent;
        }
        T commonToDestination = identity;
        Frame frame2 = destination;
        while (frame2 != common) {
            commonToDestination = compose.apply(getTransform.apply(frame2), commonToDestination);
            frame2 = frame2.parent;
        }
        return compose.apply(inverse.apply(commonToInstance), commonToDestination);
    }

    public TransformProvider getTransformProvider() {
        return this.transformProvider;
    }

    private static Frame findCommon(Frame from, Frame to) {
        Frame currentT;
        Frame currentF = from.depth > to.depth ? from.getAncestor(from.depth - to.depth) : from;
        Frame frame = currentT = from.depth > to.depth ? to : to.getAncestor(to.depth - from.depth);
        while (currentF != currentT) {
            currentF = currentF.parent;
            currentT = currentT.parent;
        }
        return currentF;
    }

    public boolean isChildOf(Frame potentialAncestor) {
        if (this.depth <= potentialAncestor.depth) {
            return false;
        }
        return this.getAncestor(this.depth - potentialAncestor.depth) == potentialAncestor;
    }

    public static Frame getRoot() {
        return LazyRootHolder.INSTANCE;
    }

    public Frame getFrozenFrame(Frame reference, AbsoluteDate freezingDate, String frozenName) {
        return new Frame(reference, reference.getTransformTo(this, freezingDate).freeze(), frozenName, reference.isPseudoInertial());
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 4067764035816491212L;

        private DataTransferObject() {
        }

        private Object readResolve() {
            return Frame.getRoot();
        }
    }

    private static class LazyRootHolder {
        private static final Frame INSTANCE = new Frame(Predefined.GCRF.getName(), true){
            private static final long serialVersionUID = -2654403496396721543L;

            private Object writeReplace() {
                return new DataTransferObject();
            }
        };

        private LazyRootHolder() {
        }
    }
}

