/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.StaticTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStamped;

public interface FieldStaticTransform<T extends CalculusFieldElement<T>>
extends TimeStamped {
    public static <T extends CalculusFieldElement<T>> FieldStaticTransform<T> getIdentity(final Field<T> field) {
        return new FieldStaticTransform<T>(){

            @Override
            public FieldVector3D<T> getTranslation() {
                return FieldVector3D.getZero((Field)field);
            }

            @Override
            public FieldRotation<T> getRotation() {
                return FieldRotation.getIdentity((Field)field);
            }

            @Override
            public FieldStaticTransform<T> getStaticInverse() {
                return this.getInverse();
            }

            @Override
            public FieldStaticTransform<T> getInverse() {
                return this;
            }

            @Override
            public AbsoluteDate getDate() {
                return AbsoluteDate.ARBITRARY_EPOCH;
            }

            @Override
            public FieldVector3D<T> transformVector(FieldVector3D<T> vector) {
                return new FieldVector3D(vector.getX(), vector.getY(), vector.getZ());
            }

            @Override
            public FieldVector3D<T> transformVector(Vector3D vector) {
                return new FieldVector3D(field, vector);
            }

            @Override
            public FieldVector3D<T> transformPosition(FieldVector3D<T> position) {
                return this.transformVector(position);
            }

            @Override
            public FieldVector3D<T> transformPosition(Vector3D position) {
                return this.transformVector(position);
            }
        };
    }

    default public FieldVector3D<T> transformPosition(Vector3D position) {
        return this.getRotation().applyTo(this.getTranslation().add(position));
    }

    default public FieldVector3D<T> transformPosition(FieldVector3D<T> position) {
        return this.getRotation().applyTo(position.add(this.getTranslation()));
    }

    default public FieldVector3D<T> transformVector(Vector3D vector) {
        return this.getRotation().applyTo(vector);
    }

    default public FieldVector3D<T> transformVector(FieldVector3D<T> vector) {
        return this.getRotation().applyTo(vector);
    }

    default public FieldLine<T> transformLine(Line line) {
        FieldVector3D<T> transformedP0 = this.transformPosition(line.getOrigin());
        FieldVector3D<T> transformedP1 = this.transformPosition(line.pointAt(1000000.0));
        return new FieldLine(transformedP0, transformedP1, line.getTolerance());
    }

    default public FieldLine<T> transformLine(FieldLine<T> line) {
        FieldVector3D<T> transformedP0 = this.transformPosition(line.getOrigin());
        FieldVector3D<T> transformedP1 = this.transformPosition(line.pointAt(1000000.0));
        return new FieldLine(transformedP0, transformedP1, line.getTolerance());
    }

    default public FieldAbsoluteDate<T> getFieldDate() {
        return new FieldAbsoluteDate(this.getTranslation().getX().getField(), this.getDate());
    }

    public FieldVector3D<T> getTranslation();

    public FieldRotation<T> getRotation();

    public FieldStaticTransform<T> getInverse();

    default public FieldStaticTransform<T> getStaticInverse() {
        FieldVector3D negatedTranslation = this.getTranslation().negate();
        FieldRotation<T> rotation = this.getRotation();
        return FieldStaticTransform.of(this.getFieldDate(), rotation.applyTo(negatedTranslation), rotation.revert());
    }

    public static <T extends CalculusFieldElement<T>> FieldStaticTransform<T> compose(FieldAbsoluteDate<T> date, FieldStaticTransform<T> first, FieldStaticTransform<T> second) {
        return FieldStaticTransform.of(date, FieldStaticTransform.compositeTranslation(first, second), FieldStaticTransform.compositeRotation(first, second));
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> compositeTranslation(FieldStaticTransform<T> first, FieldStaticTransform<T> second) {
        FieldVector3D<T> p1 = first.getTranslation();
        FieldRotation<T> r1 = first.getRotation();
        FieldVector3D<T> p2 = second.getTranslation();
        return p1.add(r1.applyInverseTo(p2));
    }

    public static <T extends CalculusFieldElement<T>> FieldRotation<T> compositeRotation(FieldStaticTransform<T> first, FieldStaticTransform<T> second) {
        FieldRotation<T> r1 = first.getRotation();
        FieldRotation<T> r2 = second.getRotation();
        return r1.compose(r2, RotationConvention.FRAME_TRANSFORM);
    }

    public static <T extends CalculusFieldElement<T>> FieldStaticTransform<T> of(FieldAbsoluteDate<T> date, FieldRotation<T> rotation) {
        return FieldStaticTransform.of(date, FieldVector3D.getZero(date.getField()), rotation);
    }

    public static <T extends CalculusFieldElement<T>> FieldStaticTransform<T> of(FieldAbsoluteDate<T> date, FieldVector3D<T> translation) {
        return FieldStaticTransform.of(date, translation, FieldRotation.getIdentity(date.getField()));
    }

    public static <T extends CalculusFieldElement<T>> FieldStaticTransform<T> of(FieldAbsoluteDate<T> date, StaticTransform staticTransform) {
        return FieldStaticTransform.of(date, new FieldVector3D(date.getField(), staticTransform.getTranslation()), new FieldRotation(date.getField(), staticTransform.getRotation()));
    }

    public static <T extends CalculusFieldElement<T>> FieldStaticTransform<T> of(final FieldAbsoluteDate<T> date, final FieldVector3D<T> translation, final FieldRotation<T> rotation) {
        return new FieldStaticTransform<T>(){

            @Override
            public FieldStaticTransform<T> getInverse() {
                FieldRotation r = this.getRotation();
                FieldVector3D rp = r.applyTo(this.getTranslation());
                FieldVector3D pInv = rp.negate();
                return FieldStaticTransform.of(date, pInv, rotation.revert());
            }

            @Override
            public AbsoluteDate getDate() {
                return date.toAbsoluteDate();
            }

            @Override
            public FieldAbsoluteDate<T> getFieldDate() {
                return date;
            }

            @Override
            public FieldVector3D<T> getTranslation() {
                return translation;
            }

            @Override
            public FieldRotation<T> getRotation() {
                return rotation;
            }
        };
    }
}

