/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.KinematicTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public interface FieldKinematicTransform<T extends CalculusFieldElement<T>>
extends FieldStaticTransform<T> {
    public static <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> getIdentity(Field<T> field) {
        return FieldTransform.getIdentity(field);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> compositeVelocity(FieldKinematicTransform<T> first, FieldKinematicTransform<T> second) {
        FieldVector3D<T> v1 = first.getVelocity();
        FieldRotation r1 = first.getRotation();
        FieldVector3D<T> o1 = first.getRotationRate();
        FieldVector3D p2 = second.getTranslation();
        FieldVector3D<T> v2 = second.getVelocity();
        FieldVector3D crossP = FieldVector3D.crossProduct(o1, p2);
        return v1.add(r1.applyInverseTo(v2.add(crossP)));
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> compositeRotationRate(FieldKinematicTransform<T> first, FieldKinematicTransform<T> second) {
        FieldVector3D<T> o1 = first.getRotationRate();
        FieldRotation r2 = second.getRotation();
        FieldVector3D<T> o2 = second.getRotationRate();
        return o2.add(r2.applyTo(o1));
    }

    default public FieldPVCoordinates<T> transformOnlyPV(FieldPVCoordinates<T> pv) {
        FieldVector3D<T> transformedP = this.transformPosition(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.getRotationRate(), transformedP);
        FieldVector3D transformedV = this.getRotation().applyTo(pv.getVelocity().add(this.getVelocity())).subtract(crossP);
        return new FieldPVCoordinates<T>(transformedP, transformedV);
    }

    default public TimeStampedFieldPVCoordinates<T> transformOnlyPV(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = this.transformPosition(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.getRotationRate(), transformedP);
        FieldVector3D transformedV = this.getRotation().applyTo(pv.getVelocity().add(this.getVelocity())).subtract(crossP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, FieldVector3D.getZero(pv.getDate().getField()));
    }

    default public T[][] getPVJacobian() {
        Field field = this.getFieldDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)6, (int)6);
        CalculusFieldElement[][] mData = this.getRotation().getMatrix();
        System.arraycopy(mData[0], 0, jacobian[0], 0, 3);
        System.arraycopy(mData[1], 0, jacobian[1], 0, 3);
        System.arraycopy(mData[2], 0, jacobian[2], 0, 3);
        Arrays.fill(jacobian[0], 3, 6, zero);
        Arrays.fill(jacobian[1], 3, 6, zero);
        Arrays.fill(jacobian[2], 3, 6, zero);
        FieldVector3D<T> o = this.getRotationRate();
        CalculusFieldElement ox = o.getX();
        CalculusFieldElement oy = o.getY();
        CalculusFieldElement oz = o.getZ();
        for (int i = 0; i < 3; ++i) {
            jacobian[3][i] = (CalculusFieldElement)((CalculusFieldElement)oz.multiply((FieldElement)mData[1][i])).subtract((FieldElement)((CalculusFieldElement)oy.multiply((FieldElement)mData[2][i])));
            jacobian[4][i] = (CalculusFieldElement)((CalculusFieldElement)ox.multiply((FieldElement)mData[2][i])).subtract((FieldElement)((CalculusFieldElement)oz.multiply((FieldElement)mData[0][i])));
            jacobian[5][i] = (CalculusFieldElement)((CalculusFieldElement)oy.multiply((FieldElement)mData[0][i])).subtract((FieldElement)((CalculusFieldElement)ox.multiply((FieldElement)mData[1][i])));
        }
        System.arraycopy(mData[0], 0, jacobian[3], 3, 3);
        System.arraycopy(mData[1], 0, jacobian[4], 3, 3);
        System.arraycopy(mData[2], 0, jacobian[5], 3, 3);
        return jacobian;
    }

    public FieldVector3D<T> getVelocity();

    public FieldVector3D<T> getRotationRate();

    @Override
    public FieldKinematicTransform<T> getInverse();

    public static <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> compose(FieldAbsoluteDate<T> date, FieldKinematicTransform<T> first, FieldKinematicTransform<T> second) {
        FieldVector3D<T> composedTranslation = FieldStaticTransform.compositeTranslation(first, second);
        FieldVector3D<T> composedTranslationRate = FieldKinematicTransform.compositeVelocity(first, second);
        return FieldKinematicTransform.of(date, new FieldPVCoordinates<T>(composedTranslation, composedTranslationRate), FieldStaticTransform.compositeRotation(first, second), FieldKinematicTransform.compositeRotationRate(first, second));
    }

    public static <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> of(FieldAbsoluteDate<T> date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate) {
        return FieldKinematicTransform.of(date, FieldPVCoordinates.getZero(date.getField()), rotation, rotationRate);
    }

    public static <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> of(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pvCoordinates) {
        Field<T> field = date.getField();
        return FieldKinematicTransform.of(date, pvCoordinates, FieldRotation.getIdentity(field), FieldVector3D.getZero(field));
    }

    public static <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> of(Field<T> field, KinematicTransform kinematicTransform) {
        FieldAbsoluteDate<T> date = new FieldAbsoluteDate<T>(field, kinematicTransform.getDate());
        FieldPVCoordinates<Field<T>> pvCoordinates = new FieldPVCoordinates<Field<T>>(field, new PVCoordinates(kinematicTransform.getTranslation(), kinematicTransform.getVelocity()));
        FieldRotation rotation = new FieldRotation(field, kinematicTransform.getRotation());
        FieldVector3D rotationRate = new FieldVector3D(field, kinematicTransform.getRotationRate());
        return FieldKinematicTransform.of(date, pvCoordinates, rotation, rotationRate);
    }

    public static <T extends CalculusFieldElement<T>> FieldKinematicTransform<T> of(final FieldAbsoluteDate<T> date, final FieldPVCoordinates<T> pvCoordinates, final FieldRotation<T> rotation, final FieldVector3D<T> rotationRate) {
        return new FieldKinematicTransform<T>(){

            @Override
            public FieldKinematicTransform<T> getInverse() {
                FieldRotation r = this.getRotation();
                FieldVector3D rp = r.applyTo(this.getTranslation());
                FieldVector3D pInv = rp.negate();
                FieldVector3D crossP = FieldVector3D.crossProduct(this.getRotationRate(), (FieldVector3D)rp);
                FieldVector3D vInv = crossP.subtract(this.getRotation().applyTo(this.getVelocity()));
                FieldRotation rInv = r.revert();
                return FieldKinematicTransform.of(date, new FieldPVCoordinates(pInv, vInv), rInv, rInv.applyTo(this.getRotationRate()).negate());
            }

            @Override
            public AbsoluteDate getDate() {
                return date.toAbsoluteDate();
            }

            @Override
            public FieldAbsoluteDate<T> getFieldDate() {
                return date;
            }

            @Override
            public FieldVector3D<T> getTranslation() {
                return pvCoordinates.getPosition();
            }

            @Override
            public FieldRotation<T> getRotation() {
                return rotation;
            }

            @Override
            public FieldVector3D<T> getVelocity() {
                return pvCoordinates.getVelocity();
            }

            @Override
            public FieldVector3D<T> getRotationRate() {
                return rotationRate;
            }
        };
    }
}

