/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.orekit.data.DataLoader;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EopHistoryLoader;

class EopParserLoader
implements DataLoader {
    private final EopHistoryLoader.Parser parser;
    private final List<EOPEntry> history;

    EopParserLoader(EopHistoryLoader.Parser parser) {
        this.parser = parser;
        this.history = new ArrayList<EOPEntry>();
    }

    public Collection<EOPEntry> getEop() {
        return this.history;
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        this.history.addAll(this.parser.parse(input, name));
    }
}

