/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.SortedSet;
import org.orekit.frames.BulletinBFilesLoader;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EopC04FilesLoader;
import org.orekit.frames.EopXmlLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.frames.RapidDataAndPredictionColumnsLoader;
import org.orekit.time.TimeScales;
import org.orekit.utils.IERSConventions;

public interface EopHistoryLoader {
    public void fillHistory(IERSConventions.NutationCorrectionConverter var1, SortedSet<EOPEntry> var2);

    public static interface Parser {
        public Collection<EOPEntry> parse(InputStream var1, String var2) throws IOException;

        public static Parser newFinalsXmlParser(IERSConventions conventions, ItrfVersionProvider itrfVersionProvider, TimeScales timeScales) {
            return new EopXmlLoader.Parser(conventions.getNutationCorrectionConverter(timeScales), itrfVersionProvider, timeScales.getUTC());
        }

        public static Parser newFinalsColumnsParser(IERSConventions conventions, ItrfVersionProvider itrfVersionProvider, TimeScales timeScales, boolean isNonRotatingOrigin) {
            return new RapidDataAndPredictionColumnsLoader.Parser(conventions.getNutationCorrectionConverter(timeScales), itrfVersionProvider, timeScales.getUTC(), isNonRotatingOrigin);
        }

        public static Parser newEopC04Parser(IERSConventions conventions, ItrfVersionProvider itrfVersionProvider, TimeScales timeScales) {
            return new EopC04FilesLoader.Parser(conventions.getNutationCorrectionConverter(timeScales), timeScales.getUTC());
        }

        public static Parser newBulletinBParser(IERSConventions conventions, ItrfVersionProvider itrfVersionProvider, TimeScales timeScales) {
            return new BulletinBFilesLoader.Parser(conventions.getNutationCorrectionConverter(timeScales), itrfVersionProvider, timeScales.getUTC());
        }
    }
}

