/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Supplier;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EopHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;

class EopCsvFilesLoader
extends AbstractEopLoader
implements EopHistoryLoader {
    private static final String SEPARATOR = ";";
    private static final String MJD = "MJD";
    private static final String YEAR = "Year";
    private static final String MONTH = "Month";
    private static final String DAY = "Day";
    private static final String X_POLE = "x_pole";
    private static final String Y_POLE = "y_pole";
    private static final String X_RATE = "x_rate";
    private static final String Y_RATE = "y_rate";
    private static final String UT1_UTC = "UT1-UTC";
    private static final String LOD = "LOD";
    private static final String DPSI = "dPsi";
    private static final String DEPSILON = "dEpsilon";
    private static final String DX = "dX";
    private static final String DY = "dY";
    private static final Unit MAS = Unit.parse("mas");
    private static final Unit MAS_D = Unit.parse("mas/day");
    private static final Unit MS = Unit.parse("ms");

    EopCsvFilesLoader(String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        Parser parser = new Parser(converter, this.getUtc());
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    class Parser
    extends AbstractEopParser {
        private final ItrfVersionProvider itrfVersionProvider;
        private int mjdColumn;
        private int yearColumn;
        private int monthColumn;
        private int dayColumn;
        private int xPoleColumn;
        private int yPoleColumn;
        private int xRatePoleColumn;
        private int yRatePoleColumn;
        private int ut1Column;
        private int lodColumn;
        private int dxColumn;
        private int dyColumn;
        private int dPsiColumn;
        private int dEpsilonColumn;
        private ITRFVersionLoader.ITRFVersionConfiguration configuration;

        Parser(IERSConventions.NutationCorrectionConverter converter, TimeScale utc) {
            super(converter, null, utc);
            this.itrfVersionProvider = new ITRFVersionLoader("itrf-versions.conf", EopCsvFilesLoader.this.getDataProvidersManager());
        }

        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException, OrekitException {
            ArrayList<EOPEntry> history = new ArrayList<EOPEntry>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                int lineNumber = 0;
                this.configuration = null;
                String line = reader.readLine();
                while (line != null) {
                    boolean parsed;
                    if (++lineNumber == 1) {
                        parsed = this.parseHeaderLine(line);
                    } else {
                        history.add(this.parseDataLine(line, name));
                        parsed = true;
                    }
                    if (!parsed) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    line = reader.readLine();
                }
                if (lineNumber < 2) {
                    throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
                }
            }
            return history;
        }

        private boolean parseHeaderLine(String headerLine) {
            this.mjdColumn = -1;
            this.yearColumn = -1;
            this.monthColumn = -1;
            this.dayColumn = -1;
            this.xPoleColumn = -1;
            this.yPoleColumn = -1;
            this.xRatePoleColumn = -1;
            this.yRatePoleColumn = -1;
            this.ut1Column = -1;
            this.lodColumn = -1;
            this.dxColumn = -1;
            this.dyColumn = -1;
            this.dPsiColumn = -1;
            this.dEpsilonColumn = -1;
            String[] fields = headerLine.split(EopCsvFilesLoader.SEPARATOR);
            block32: for (int column = 0; column < fields.length; ++column) {
                switch (fields[column]) {
                    case "MJD": {
                        this.mjdColumn = column;
                        continue block32;
                    }
                    case "Year": {
                        this.yearColumn = column;
                        continue block32;
                    }
                    case "Month": {
                        this.monthColumn = column;
                        continue block32;
                    }
                    case "Day": {
                        this.dayColumn = column;
                        continue block32;
                    }
                    case "x_pole": {
                        this.xPoleColumn = column;
                        continue block32;
                    }
                    case "y_pole": {
                        this.yPoleColumn = column;
                        continue block32;
                    }
                    case "x_rate": {
                        this.xRatePoleColumn = column;
                        continue block32;
                    }
                    case "y_rate": {
                        this.yRatePoleColumn = column;
                        continue block32;
                    }
                    case "UT1-UTC": {
                        this.ut1Column = column;
                        continue block32;
                    }
                    case "LOD": {
                        this.lodColumn = column;
                        continue block32;
                    }
                    case "dX": {
                        this.dxColumn = column;
                        continue block32;
                    }
                    case "dY": {
                        this.dyColumn = column;
                        continue block32;
                    }
                    case "dPsi": {
                        this.dPsiColumn = column;
                        continue block32;
                    }
                    case "dEpsilon": {
                        this.dEpsilonColumn = column;
                        continue block32;
                    }
                }
            }
            return this.mjdColumn >= 0 && this.yearColumn >= 0 && this.monthColumn >= 0 && this.dayColumn >= 0 && this.xPoleColumn >= 0 && this.yPoleColumn >= 0 && this.ut1Column >= 0 && this.lodColumn >= 0 && (this.dxColumn >= 0 && this.dyColumn >= 0 || this.dPsiColumn >= 0 && this.dEpsilonColumn >= 0);
        }

        private EOPEntry parseDataLine(String line, String name) {
            String[] fields = line.split(EopCsvFilesLoader.SEPARATOR);
            DateComponents dc = new DateComponents(Integer.parseInt(fields[this.yearColumn]), Integer.parseInt(fields[this.monthColumn]), Integer.parseInt(fields[this.dayColumn]));
            int mjd = Integer.parseInt(fields[this.mjdColumn]);
            if (dc.getMJD() != mjd) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, dc.getYear(), dc.getMonth(), dc.getDay(), mjd);
            }
            AbsoluteDate date = new AbsoluteDate(dc, this.getUtc());
            if (this.configuration == null || !this.configuration.isValid(mjd)) {
                this.configuration = this.itrfVersionProvider.getConfiguration(name, mjd);
            }
            double x = this.parseField(fields, this.xPoleColumn, MAS);
            double y = this.parseField(fields, this.yPoleColumn, MAS);
            double xRate = this.parseField(fields, this.xRatePoleColumn, MAS_D);
            double yRate = this.parseField(fields, this.yRatePoleColumn, MAS_D);
            double dtu1 = this.parseField(fields, this.ut1Column, MS);
            double lod = this.parseField(fields, this.lodColumn, MS);
            if (this.dxColumn >= 0) {
                double dx = this.parseField(fields, this.dxColumn, MAS);
                double dy = this.parseField(fields, this.dyColumn, MAS);
                double[] equinox = this.getConverter().toEquinox(date, dx, dy);
                return new EOPEntry(dc.getMJD(), dtu1, lod, x, y, xRate, yRate, equinox[0], equinox[1], dx, dy, this.configuration.getVersion(), date);
            }
            double ddPsi = this.parseField(fields, this.dPsiColumn, MAS);
            double dddEpsilon = this.parseField(fields, this.dEpsilonColumn, MAS);
            double[] nro = this.getConverter().toNonRotating(date, ddPsi, dddEpsilon);
            return new EOPEntry(dc.getMJD(), dtu1, lod, x, y, xRate, yRate, ddPsi, dddEpsilon, nro[0], nro[1], this.configuration.getVersion(), date);
        }

        private double parseField(String[] fields, int index, Unit unit) {
            return index < 0 || index >= fields.length || fields[index].isEmpty() ? Double.NaN : unit.toSI(Double.parseDouble(fields[index]));
        }
    }
}

