/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EopHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersion;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;

class EopC04FilesLoader
extends AbstractEopLoader
implements EopHistoryLoader {
    EopC04FilesLoader(String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        Parser parser = new Parser(converter, this.getUtc());
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    static class Parser
    extends AbstractEopParser {
        Parser(IERSConventions.NutationCorrectionConverter converter, TimeScale utc) {
            super(converter, null, utc);
        }

        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException, OrekitException {
            ArrayList<EOPEntry> history = new ArrayList<EOPEntry>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                int lineNumber = 0;
                boolean inHeader = true;
                LineParser[] tentativeParsers = new LineParser[]{new LineWithoutRatesParser(name), new LineWithRatesParser(name)};
                LineParser selectedParser = null;
                String line = reader.readLine();
                while (line != null) {
                    EOPEntry entry;
                    ++lineNumber;
                    boolean parsed = false;
                    if (inHeader) {
                        for (LineParser parser : tentativeParsers) {
                            if (!parser.parseHeaderLine(line)) continue;
                            selectedParser = parser;
                            break;
                        }
                    }
                    if (selectedParser != null && (entry = selectedParser.parseDataLine(line)) != null) {
                        history.add(entry);
                        parsed = true;
                        inHeader = false;
                    }
                    if (!inHeader && !parsed) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    line = reader.readLine();
                }
                if (inHeader) {
                    throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
                }
            }
            return history;
        }

        private class LineWithRatesParser
        extends LineParser {
            private static final int YEAR_GROUP = 1;
            private static final int MONTH_GROUP = 2;
            private static final int DAY_GROUP = 3;
            private static final int HOUR_GROUP = 4;
            private static final int MJD_GROUP = 5;
            private static final int POLE_X_GROUP = 6;
            private static final int POLE_Y_GROUP = 7;
            private static final int UT1_UTC_GROUP = 8;
            private static final int NUT_DX_GROUP = 9;
            private static final int NUT_DY_GROUP = 10;
            private static final int POLE_X_RATE_GROUP = 11;
            private static final int POLE_Y_RATE_GROUP = 12;
            private static final int LOD_GROUP = 13;

            LineWithRatesParser(String name) {
                super("^# +EOP +\\(IERS\\) +([0-9][0-9]) +C04.*", "^# +YR +MM +DD +H +MJD +x\\(\"\\) +y\\(\"\\) +UT1-UTC\\(s\\) +dX\\(\"\\) +dY\\(\"\\) +xrt\\(\"\\) +yrt\\'\"\\) +.*", "^(\\d+) +(\\d+) +(\\d+) +(\\d+) +(\\d+)\\.\\d+ +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+)(?: +(-?\\d+\\.\\d+)){8}$", 1, 2, 3, 5, name);
            }

            @Override
            protected void parseColumnsHeaderLine(Matcher matcher) {
            }

            @Override
            protected EOPEntry parseDataLine(Matcher matcher, DateComponents dc) {
                TimeComponents tc = new TimeComponents(Integer.parseInt(matcher.group(4)), 0, 0.0);
                AbsoluteDate date = new AbsoluteDate(dc, tc, Parser.this.getUtc());
                double x = Double.parseDouble(matcher.group(6)) * 4.84813681109536E-6;
                double y = Double.parseDouble(matcher.group(7)) * 4.84813681109536E-6;
                double xRate = Double.parseDouble(matcher.group(11)) * 4.84813681109536E-6 / 86400.0;
                double yRate = Double.parseDouble(matcher.group(12)) * 4.84813681109536E-6 / 86400.0;
                double dtu1 = Double.parseDouble(matcher.group(8));
                double lod = Double.parseDouble(matcher.group(13));
                double[] nro = new double[]{Double.parseDouble(matcher.group(9)) * 4.84813681109536E-6, Double.parseDouble(matcher.group(10)) * 4.84813681109536E-6};
                double[] equinox = Parser.this.getConverter().toEquinox(date, nro[0], nro[1]);
                return new EOPEntry(dc.getMJD(), dtu1, lod, x, y, xRate, yRate, equinox[0], equinox[1], nro[0], nro[1], this.getItrfVersion(), date);
            }
        }

        private class LineWithoutRatesParser
        extends LineParser {
            private static final int NUTATION_HEADER_GROUP = 1;
            private static final int YEAR_GROUP = 1;
            private static final int MONTH_GROUP = 2;
            private static final int DAY_GROUP = 3;
            private static final int MJD_GROUP = 4;
            private static final int POLE_X_GROUP = 5;
            private static final int POLE_Y_GROUP = 6;
            private static final int UT1_UTC_GROUP = 7;
            private static final int LOD_GROUP = 8;
            private static final int NUT_0_GROUP = 9;
            private static final int NUT_1_GROUP = 10;
            private boolean isNonRotatingOrigin;

            LineWithoutRatesParser(String name) {
                super("^ +EOP +\\(IERS\\) +([0-9][0-9]) +C04.*", "^ *Date +MJD +x +y +UT1-UTC +LOD +((?:dPsi +dEps)|(?:dX +dY)) .*", "^(\\d+) +(\\d+) +(\\d+) +(\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+) +(-?\\d+\\.\\d+)(?: +(-?\\d+\\.\\d+)){6}$", 1, 2, 3, 4, name);
            }

            @Override
            protected void parseColumnsHeaderLine(Matcher matcher) {
                this.isNonRotatingOrigin = matcher.group(1).startsWith("dX");
            }

            @Override
            protected EOPEntry parseDataLine(Matcher matcher, DateComponents dc) {
                double[] equinox;
                double[] nro;
                AbsoluteDate date = new AbsoluteDate(dc, Parser.this.getUtc());
                double x = Double.parseDouble(matcher.group(5)) * 4.84813681109536E-6;
                double y = Double.parseDouble(matcher.group(6)) * 4.84813681109536E-6;
                double dtu1 = Double.parseDouble(matcher.group(7));
                double lod = Double.parseDouble(matcher.group(8));
                if (this.isNonRotatingOrigin) {
                    nro = new double[]{Double.parseDouble(matcher.group(9)) * 4.84813681109536E-6, Double.parseDouble(matcher.group(10)) * 4.84813681109536E-6};
                    equinox = Parser.this.getConverter().toEquinox(date, nro[0], nro[1]);
                } else {
                    equinox = new double[]{Double.parseDouble(matcher.group(9)) * 4.84813681109536E-6, Double.parseDouble(matcher.group(10)) * 4.84813681109536E-6};
                    nro = Parser.this.getConverter().toNonRotating(date, equinox[0], equinox[1]);
                }
                return new EOPEntry(dc.getMJD(), dtu1, lod, x, y, Double.NaN, Double.NaN, equinox[0], equinox[1], nro[0], nro[1], this.getItrfVersion(), date);
            }
        }

        private abstract class LineParser {
            private final Pattern itrfVersionPattern;
            private final Pattern columnHeaderPattern;
            private final Pattern dataPattern;
            private final int yearGroup;
            private final int monthGroup;
            private final int dayGroup;
            private final int mjdGroup;
            private final String name;
            private ITRFVersion itrfVersion;

            protected LineParser(String itrfVersionRegexp, String columnsHeaderRegexp, String dataRegexp, int yearGroup, int monthGroup, int dayGroup, int mjdGroup, String name) {
                this.itrfVersionPattern = Pattern.compile(itrfVersionRegexp);
                this.columnHeaderPattern = Pattern.compile(columnsHeaderRegexp);
                this.dataPattern = Pattern.compile(dataRegexp);
                this.yearGroup = yearGroup;
                this.monthGroup = monthGroup;
                this.dayGroup = dayGroup;
                this.mjdGroup = mjdGroup;
                this.name = name;
            }

            protected ITRFVersion getItrfVersion() {
                return this.itrfVersion;
            }

            public boolean parseHeaderLine(String line) {
                Matcher itrfVersionMatcher = this.itrfVersionPattern.matcher(line);
                if (itrfVersionMatcher.matches()) {
                    switch (Integer.parseInt(itrfVersionMatcher.group(1))) {
                        case 5: {
                            this.itrfVersion = ITRFVersion.ITRF_2005;
                            break;
                        }
                        case 8: {
                            this.itrfVersion = ITRFVersion.ITRF_2008;
                            break;
                        }
                        case 14: {
                            this.itrfVersion = ITRFVersion.ITRF_2014;
                            break;
                        }
                        case 20: {
                            this.itrfVersion = ITRFVersion.ITRF_2020;
                            break;
                        }
                        default: {
                            throw new OrekitException((Localizable)OrekitMessages.NO_SUCH_ITRF_FRAME, itrfVersionMatcher.group(1));
                        }
                    }
                    return true;
                }
                Matcher columnHeaderMatcher = this.columnHeaderPattern.matcher(line);
                if (columnHeaderMatcher.matches()) {
                    this.parseColumnsHeaderLine(columnHeaderMatcher);
                    return true;
                }
                return false;
            }

            public EOPEntry parseDataLine(String line) {
                Matcher matcher = this.dataPattern.matcher(line);
                if (!matcher.matches()) {
                    return null;
                }
                DateComponents dc = new DateComponents(Integer.parseInt(matcher.group(this.yearGroup)), Integer.parseInt(matcher.group(this.monthGroup)), Integer.parseInt(matcher.group(this.dayGroup)));
                int mjd = Integer.parseInt(matcher.group(this.mjdGroup));
                if (dc.getMJD() != mjd) {
                    throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, this.name, dc.getYear(), dc.getMonth(), dc.getDay(), mjd);
                }
                return this.parseDataLine(matcher, dc);
            }

            protected abstract void parseColumnsHeaderLine(Matcher var1);

            protected abstract EOPEntry parseDataLine(Matcher var1, DateComponents var2);
        }
    }
}

