/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EopHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.UnitsConverter;

class BulletinBFilesLoader
extends AbstractEopLoader
implements EopHistoryLoader {
    private static final Pattern SECTION_1_HEADER = Pattern.compile("^ +1 - (\\p{Upper}+) \\p{Upper}+ \\p{Upper}+.*");
    private static final Pattern SECTION_2_HEADER_OLD = Pattern.compile("^ +2 - SMOOTHED \\p{Upper}+ \\p{Upper}+.*((?:DPSI, DEPSILON)|(?:dX, dY)).*");
    private static final Pattern SECTION_3_HEADER = Pattern.compile("^ +3 - \\p{Upper}+ \\p{Upper}+ \\p{Upper}+.*");
    private static final Pattern FINAL_VALUES_START = Pattern.compile("^\\p{Blank}+Final( Bulletin B)? values.*");
    private static final Pattern FINAL_VALUES_END = Pattern.compile("^\\p{Blank}+Preliminary extension.*");
    private static final Pattern SECTION_1_DATA_OLD_FORMAT;
    private static final Pattern SECTION_2_DATA_OLD_FORMAT;
    private static final Pattern SECTION_1_DATA_NEW_FORMAT;
    private static final Pattern SECTION_3_DATA_NEW_FORMAT;

    BulletinBFilesLoader(String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        ITRFVersionLoader itrfVersionProvider = new ITRFVersionLoader("itrf-versions.conf", this.getDataProvidersManager());
        Parser parser = new Parser(converter, itrfVersionProvider, this.getUtc());
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    static {
        StringBuilder builder = new StringBuilder("^\\p{Blank}+(?:");
        for (Month month : Month.values()) {
            builder.append(month.getUpperCaseAbbreviation());
            builder.append('|');
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(")");
        String integerPattern = "[-+]?\\p{Digit}+";
        String realPattern = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
        String monthNameField = builder.toString();
        String ignoredIntegerField = "\\p{Blank}*[-+]?\\p{Digit}+";
        String storedIntegerField = "\\p{Blank}*([-+]?\\p{Digit}+)";
        String mjdField = "\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})";
        String storedRealField = "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)";
        String ignoredRealField = "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
        String finalBlanks = "\\p{Blank}*$";
        SECTION_1_DATA_OLD_FORMAT = Pattern.compile(monthNameField + "\\p{Blank}*[-+]?\\p{Digit}+" + "\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}*$");
        SECTION_2_DATA_OLD_FORMAT = Pattern.compile(monthNameField + "\\p{Blank}*[-+]?\\p{Digit}+" + "\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})" + "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)" + "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)" + "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)" + "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?" + "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)" + "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)" + "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)" + "\\p{Blank}*$");
        SECTION_1_DATA_NEW_FORMAT = Pattern.compile("\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}*$");
        SECTION_3_DATA_NEW_FORMAT = Pattern.compile("\\p{Blank}*[-+]?\\p{Digit}+\\p{Blank}*[-+]?\\p{Digit}+\\p{Blank}*[-+]?\\p{Digit}+\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}*$");
    }

    static class Parser
    extends AbstractEopParser {
        private ITRFVersionLoader.ITRFVersionConfiguration configuration;
        private List<EOPEntry> history;
        private final Map<Integer, double[]> fieldsMap = new HashMap<Integer, double[]>();
        private int lineNumber = 0;
        private String line;
        private int mjdMin = Integer.MAX_VALUE;
        private int mjdMax = Integer.MIN_VALUE;

        Parser(IERSConventions.NutationCorrectionConverter converter, ItrfVersionProvider itrfVersionProvider, TimeScale utc) {
            super(converter, itrfVersionProvider, utc);
        }

        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                this.fieldsMap.clear();
                this.lineNumber = 0;
                this.mjdMin = Integer.MAX_VALUE;
                this.mjdMax = Integer.MIN_VALUE;
                this.history = new ArrayList<EOPEntry>();
                this.configuration = null;
                Matcher section1Matcher = this.seekToLine(SECTION_1_HEADER, reader, name);
                boolean isOldFormat = "EARTH".equals(section1Matcher.group(1));
                if (isOldFormat) {
                    this.loadMJDBoundsOldFormat(reader, name);
                    Matcher section2Matcher = this.seekToLine(SECTION_2_HEADER_OLD, reader, name);
                    boolean isNonRotatingOrigin = section2Matcher.group(1).startsWith("dX");
                    this.loadEOPOldFormat(isNonRotatingOrigin, reader, name);
                } else {
                    this.loadXYDTDxDyNewFormat(reader, name);
                    this.seekToLine(SECTION_3_HEADER, reader, name);
                    this.loadLODNewFormat(reader, name);
                    for (Map.Entry<Integer, double[]> entry : this.fieldsMap.entrySet()) {
                        int mjd = entry.getKey();
                        double[] array = entry.getValue();
                        if (Double.isNaN(array[0] + array[1] + array[2] + array[3] + array[4] + array[5])) {
                            throw this.notifyUnexpectedErrorEncountered(name);
                        }
                        AbsoluteDate mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), this.getUtc());
                        double[] equinox = this.getConverter().toEquinox(mjdDate, array[4], array[5]);
                        if (this.configuration == null || !this.configuration.isValid(mjd)) {
                            this.configuration = this.getItrfVersionProvider().getConfiguration(name, mjd);
                        }
                        this.history.add(new EOPEntry(mjd, array[0], array[1], array[2], array[3], Double.NaN, Double.NaN, equinox[0], equinox[1], array[4], array[5], this.configuration.getVersion(), mjdDate));
                    }
                }
            }
            return this.history;
        }

        private Matcher seekToLine(Pattern pattern, BufferedReader reader, String name) throws IOException {
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                Matcher matcher = pattern.matcher(this.line);
                if (matcher.matches()) {
                    return matcher;
                }
                this.line = reader.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, name, this.lineNumber);
        }

        private void loadMJDBoundsOldFormat(BufferedReader reader, String name) throws IOException {
            boolean inFinalValuesPart = false;
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                Matcher matcher = FINAL_VALUES_START.matcher(this.line);
                if (matcher.matches()) {
                    inFinalValuesPart = true;
                } else if (inFinalValuesPart) {
                    matcher = SECTION_1_DATA_OLD_FORMAT.matcher(this.line);
                    if (matcher.matches()) {
                        int mjd = Integer.parseInt(matcher.group(1));
                        this.mjdMin = FastMath.min((int)this.mjdMin, (int)mjd);
                        this.mjdMax = FastMath.max((int)this.mjdMax, (int)mjd);
                    } else {
                        matcher = FINAL_VALUES_END.matcher(this.line);
                        if (matcher.matches()) {
                            return;
                        }
                    }
                }
                this.line = reader.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, name, this.lineNumber);
        }

        private void loadEOPOldFormat(boolean isNonRotatingOrigin, BufferedReader reader, String name) throws IOException {
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                Matcher matcher = SECTION_2_DATA_OLD_FORMAT.matcher(this.line);
                if (matcher.matches()) {
                    int mjd = Integer.parseInt(matcher.group(1));
                    double x = Double.parseDouble(matcher.group(2)) * 4.84813681109536E-6;
                    double y = Double.parseDouble(matcher.group(3)) * 4.84813681109536E-6;
                    double dtu1 = Double.parseDouble(matcher.group(4));
                    double lod = UnitsConverter.MILLI_SECONDS_TO_SECONDS.convert(Double.parseDouble(matcher.group(5)));
                    if (mjd >= this.mjdMin) {
                        double[] equinox;
                        double[] nro;
                        AbsoluteDate mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), this.getUtc());
                        if (isNonRotatingOrigin) {
                            nro = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(6))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(7)))};
                            equinox = this.getConverter().toEquinox(mjdDate, nro[0], nro[1]);
                        } else {
                            equinox = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(6))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(7)))};
                            nro = this.getConverter().toNonRotating(mjdDate, equinox[0], equinox[1]);
                        }
                        if (this.configuration == null || !this.configuration.isValid(mjd)) {
                            this.configuration = this.getItrfVersionProvider().getConfiguration(name, mjd);
                        }
                        this.history.add(new EOPEntry(mjd, dtu1, lod, x, y, Double.NaN, Double.NaN, equinox[0], equinox[1], nro[0], nro[1], this.configuration.getVersion(), mjdDate));
                        this.line = mjd < this.mjdMax ? reader.readLine() : null;
                        continue;
                    }
                    this.line = reader.readLine();
                    continue;
                }
                this.line = reader.readLine();
            }
        }

        private void loadXYDTDxDyNewFormat(BufferedReader reader, String name) throws IOException {
            boolean inFinalValuesPart = false;
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                Matcher matcher = FINAL_VALUES_START.matcher(this.line);
                if (matcher.matches()) {
                    inFinalValuesPart = true;
                    this.line = reader.readLine();
                    continue;
                }
                if (inFinalValuesPart) {
                    matcher = SECTION_1_DATA_NEW_FORMAT.matcher(this.line);
                    if (matcher.matches()) {
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int day = Integer.parseInt(matcher.group(3));
                        int mjd = Integer.parseInt(matcher.group(4));
                        if (new DateComponents(year, month, day).getMJD() != mjd) {
                            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, year, month, day, mjd);
                        }
                        this.mjdMin = FastMath.min((int)this.mjdMin, (int)mjd);
                        this.mjdMax = FastMath.max((int)this.mjdMax, (int)mjd);
                        double x = UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(5)));
                        double y = UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(6)));
                        double dtu1 = UnitsConverter.MILLI_SECONDS_TO_SECONDS.convert(Double.parseDouble(matcher.group(7)));
                        double dx = UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(8)));
                        double dy = UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(matcher.group(9)));
                        this.fieldsMap.put(mjd, new double[]{dtu1, Double.NaN, x, y, dx, dy});
                        this.line = reader.readLine();
                        continue;
                    }
                    matcher = FINAL_VALUES_END.matcher(this.line);
                    this.line = matcher.matches() ? null : reader.readLine();
                    continue;
                }
                this.line = reader.readLine();
            }
        }

        private void loadLODNewFormat(BufferedReader reader, String name) throws IOException {
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                Matcher matcher = SECTION_3_DATA_NEW_FORMAT.matcher(this.line);
                if (matcher.matches()) {
                    int mjd = Integer.parseInt(matcher.group(1));
                    if (mjd >= this.mjdMin) {
                        double lod = UnitsConverter.MILLI_SECONDS_TO_SECONDS.convert(Double.parseDouble(matcher.group(2)));
                        double[] array = this.fieldsMap.get(mjd);
                        if (array == null) {
                            throw this.notifyUnexpectedErrorEncountered(name);
                        }
                        array[1] = lod;
                        this.line = mjd >= this.mjdMax ? null : reader.readLine();
                        continue;
                    }
                    this.line = reader.readLine();
                    continue;
                }
                this.line = reader.readLine();
            }
        }

        private OrekitException notifyUnexpectedErrorEncountered(String name) {
            String loaderName = BulletinBFilesLoader.class.getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            return new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
    }
}

