/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.lang.reflect.Array;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.forces.radiation.AbstractRadiationForceModel;
import org.orekit.forces.radiation.IsotropicRadiationCNES95Convention;
import org.orekit.forces.radiation.IsotropicRadiationClassicalConvention;
import org.orekit.forces.radiation.IsotropicRadiationSingleCoefficient;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FrameAdapter;
import org.orekit.utils.OccultationEngine;
import org.orekit.utils.ParameterDriver;

public class SolarRadiationPressure
extends AbstractRadiationForceModel {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private static final double SUN_CENTERED_FRAME_THRESHOLD = 1.3914E9;
    private final double kRef;
    private final ExtendedPVCoordinatesProvider sun;
    private final RadiationSensitive spacecraft;

    public SolarRadiationPressure(ExtendedPVCoordinatesProvider sun, OneAxisEllipsoid centralBody, RadiationSensitive spacecraft) {
        this(1.4959787E11, 4.56E-6, sun, centralBody, spacecraft);
    }

    public SolarRadiationPressure(double dRef, double pRef, ExtendedPVCoordinatesProvider sun, OneAxisEllipsoid centralBody, RadiationSensitive spacecraft) {
        super(sun, centralBody);
        this.kRef = pRef * dRef * dRef;
        this.sun = sun;
        this.spacecraft = spacecraft;
    }

    public RadiationSensitive getRadiationSensitiveSpacecraft() {
        return this.spacecraft;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.spacecraft instanceof IsotropicRadiationClassicalConvention || this.spacecraft instanceof IsotropicRadiationCNES95Convention || this.spacecraft instanceof IsotropicRadiationSingleCoefficient;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPosition();
        Vector3D sunPosition = this.sun.getPosition(date, frame);
        Vector3D sunSatVector = position.subtract((Vector)sunPosition);
        double r2 = sunSatVector.getNormSq();
        double ratio = this.getLightingRatio(s, sunPosition);
        double rawP = ratio * this.kRef / r2;
        Vector3D flux = new Vector3D(rawP / FastMath.sqrt((double)r2), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(s, flux, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D<T> position = s.getPosition();
        FieldVector3D<T> sunPosition = this.sun.getPosition(date, frame);
        FieldVector3D sunSatVector = position.subtract(sunPosition);
        CalculusFieldElement r2 = sunSatVector.getNormSq();
        T ratio = this.getLightingRatio(s, sunPosition);
        CalculusFieldElement rawP = (CalculusFieldElement)((CalculusFieldElement)ratio.multiply(this.kRef)).divide((FieldElement)r2);
        FieldVector3D flux = new FieldVector3D((CalculusFieldElement)rawP.divide((FieldElement)((CalculusFieldElement)r2.sqrt())), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(s, flux, (CalculusFieldElement[])parameters);
    }

    private boolean isSunCenteredFrame(Vector3D sunPositionInFrame) {
        return sunPositionInFrame.getNorm() < 1.3914E9;
    }

    private double getLightingRatio(SpacecraftState state, Vector3D sunPosition) {
        if (this.isSunCenteredFrame(sunPosition)) {
            return 1.0;
        }
        List<OccultationEngine> occultingBodies = this.getOccultingBodies();
        int n = occultingBodies.size();
        OccultationEngine.OccultationAngles[] angles = new OccultationEngine.OccultationAngles[n];
        for (int i = 0; i < n; ++i) {
            angles[i] = occultingBodies.get(i).angles(state);
        }
        double alphaSunSq = angles[0].getOccultedApparentRadius() * angles[0].getOccultedApparentRadius();
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            OccultationEngine oi = occultingBodies.get(i);
            double lightingRatioI = this.maskingRatio(angles[i]);
            if (lightingRatioI == 0.0) {
                return 0.0;
            }
            result += lightingRatioI;
            for (int j = i + 1; j < n; ++j) {
                OccultationEngine oj = occultingBodies.get(j);
                double lightingRatioJ = this.maskingRatio(angles[j]);
                if (lightingRatioJ == 0.0) {
                    return 0.0;
                }
                if (lightingRatioJ == 1.0) continue;
                OccultationEngine oij = new OccultationEngine(new FrameAdapter(oi.getOcculting().getBodyFrame()), oi.getOcculting().getEquatorialRadius(), oj.getOcculting());
                OccultationEngine.OccultationAngles aij = oij.angles(state);
                double maskingRatioIJ = this.maskingRatio(aij);
                double alphaJSq = aij.getOccultedApparentRadius() * aij.getOccultedApparentRadius();
                double mutualEclipseCorrection = (1.0 - maskingRatioIJ) * alphaJSq / alphaSunSq;
                result -= mutualEclipseCorrection;
            }
        }
        return result -= (double)(n - 1);
    }

    public double getLightingRatio(SpacecraftState state) {
        return this.getLightingRatio(state, this.sun.getPosition(state.getDate(), state.getFrame()));
    }

    private double maskingRatio(OccultationEngine.OccultationAngles angles) {
        double alphaSun;
        double alphaCentral;
        double sunSatCentralBodyAngle = angles.getSeparation();
        if (sunSatCentralBodyAngle - (alphaCentral = angles.getLimbRadius()) + (alphaSun = angles.getOccultedApparentRadius()) <= 1.0E-10) {
            return 0.0;
        }
        if (sunSatCentralBodyAngle - alphaCentral - alphaSun < -1.0E-10) {
            double sEA2 = sunSatCentralBodyAngle * sunSatCentralBodyAngle;
            double oo2sEA = 1.0 / (2.0 * sunSatCentralBodyAngle);
            double aS2 = alphaSun * alphaSun;
            double aE2 = alphaCentral * alphaCentral;
            double aE2maS2 = aE2 - aS2;
            double alpha1 = (sEA2 - aE2maS2) * oo2sEA;
            double alpha2 = (sEA2 + aE2maS2) * oo2sEA;
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            double a1oaS = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha1 / alphaSun)));
            double aS2ma12 = FastMath.max((double)almost0, (double)(aS2 - alpha1 * alpha1));
            double a2oaE = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha2 / alphaCentral)));
            double aE2ma22 = FastMath.max((double)almost0, (double)(aE2 - alpha2 * alpha2));
            double P1 = aS2 * FastMath.acos((double)a1oaS) - alpha1 * FastMath.sqrt((double)aS2ma12);
            double P2 = aE2 * FastMath.acos((double)a2oaE) - alpha2 * FastMath.sqrt((double)aE2ma22);
            return 1.0 - (P1 + P2) / (Math.PI * aS2);
        }
        return 1.0;
    }

    private <T extends CalculusFieldElement<T>> T getLightingRatio(FieldSpacecraftState<T> state, FieldVector3D<T> sunPosition) {
        CalculusFieldElement one = (CalculusFieldElement)state.getDate().getField().getOne();
        if (this.isSunCenteredFrame(sunPosition.toVector3D())) {
            return (T)one;
        }
        CalculusFieldElement zero = (CalculusFieldElement)state.getDate().getField().getZero();
        List<OccultationEngine> occultingBodies = this.getOccultingBodies();
        int n = occultingBodies.size();
        OccultationEngine.FieldOccultationAngles[] angles = (OccultationEngine.FieldOccultationAngles[])Array.newInstance(OccultationEngine.FieldOccultationAngles.class, n);
        for (int i = 0; i < n; ++i) {
            angles[i] = occultingBodies.get(i).angles(state);
        }
        CalculusFieldElement alphaSunSq = (CalculusFieldElement)angles[0].getOccultedApparentRadius().multiply(angles[0].getOccultedApparentRadius());
        CalculusFieldElement result = (CalculusFieldElement)state.getDate().getField().getZero();
        for (int i = 0; i < n; ++i) {
            OccultationEngine oi = occultingBodies.get(i);
            T lightingRatioI = this.maskingRatio(angles[i]);
            if (lightingRatioI.isZero()) {
                return (T)zero;
            }
            result = (CalculusFieldElement)result.add(lightingRatioI);
            for (int j = i + 1; j < n; ++j) {
                OccultationEngine oj = occultingBodies.get(j);
                T lightingRatioJ = this.maskingRatio(angles[j]);
                if (lightingRatioJ.isZero()) {
                    return (T)zero;
                }
                if (lightingRatioJ.getReal() == 1.0) continue;
                OccultationEngine oij = new OccultationEngine(new FrameAdapter(oi.getOcculting().getBodyFrame()), oi.getOcculting().getEquatorialRadius(), oj.getOcculting());
                OccultationEngine.FieldOccultationAngles<T> aij = oij.angles(state);
                T maskingRatioIJ = this.maskingRatio(aij);
                CalculusFieldElement alphaJSq = (CalculusFieldElement)aij.getOccultedApparentRadius().multiply(aij.getOccultedApparentRadius());
                CalculusFieldElement mutualEclipseCorrection = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)one.subtract(maskingRatioIJ)).multiply((FieldElement)alphaJSq)).divide((FieldElement)alphaSunSq);
                result = (CalculusFieldElement)result.subtract((FieldElement)mutualEclipseCorrection);
            }
        }
        result = (CalculusFieldElement)result.subtract((double)(n - 1));
        return (T)result;
    }

    public <T extends CalculusFieldElement<T>> T getLightingRatio(FieldSpacecraftState<T> state) {
        return this.getLightingRatio(state, this.sun.getPosition(state.getDate(), state.getFrame()));
    }

    private <T extends CalculusFieldElement<T>> T maskingRatio(OccultationEngine.FieldOccultationAngles<T> angles) {
        T occultedSatOcculting = angles.getSeparation();
        T alphaOcculting = angles.getLimbRadius();
        T alphaOcculted = angles.getOccultedApparentRadius();
        if (occultedSatOcculting.getReal() - alphaOcculting.getReal() + alphaOcculted.getReal() <= 1.0E-10) {
            return (T)((CalculusFieldElement)occultedSatOcculting.getField().getZero());
        }
        if (occultedSatOcculting.getReal() - alphaOcculting.getReal() - alphaOcculted.getReal() < -1.0E-10) {
            CalculusFieldElement sEA2 = (CalculusFieldElement)occultedSatOcculting.multiply(occultedSatOcculting);
            CalculusFieldElement oo2sEA = (CalculusFieldElement)((CalculusFieldElement)occultedSatOcculting.multiply(2)).reciprocal();
            CalculusFieldElement aS2 = (CalculusFieldElement)alphaOcculted.multiply(alphaOcculted);
            CalculusFieldElement aE2 = (CalculusFieldElement)alphaOcculting.multiply(alphaOcculting);
            CalculusFieldElement aE2maS2 = (CalculusFieldElement)aE2.subtract((FieldElement)aS2);
            CalculusFieldElement alpha1 = (CalculusFieldElement)((CalculusFieldElement)sEA2.subtract((FieldElement)aE2maS2)).multiply((FieldElement)oo2sEA);
            CalculusFieldElement alpha2 = (CalculusFieldElement)((CalculusFieldElement)sEA2.add((FieldElement)aE2maS2)).multiply((FieldElement)oo2sEA);
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            CalculusFieldElement a1oaS = this.min(almost1, this.max(-almost1, (CalculusFieldElement)alpha1.divide(alphaOcculted)));
            CalculusFieldElement aS2ma12 = this.max(almost0, (CalculusFieldElement)aS2.subtract((FieldElement)((CalculusFieldElement)alpha1.multiply((FieldElement)alpha1))));
            CalculusFieldElement a2oaE = this.min(almost1, this.max(-almost1, (CalculusFieldElement)alpha2.divide(alphaOcculting)));
            CalculusFieldElement aE2ma22 = this.max(almost0, (CalculusFieldElement)aE2.subtract((FieldElement)((CalculusFieldElement)alpha2.multiply((FieldElement)alpha2))));
            CalculusFieldElement P1 = (CalculusFieldElement)((CalculusFieldElement)aS2.multiply((FieldElement)((CalculusFieldElement)a1oaS.acos()))).subtract((FieldElement)((CalculusFieldElement)alpha1.multiply((FieldElement)((CalculusFieldElement)aS2ma12.sqrt()))));
            CalculusFieldElement P2 = (CalculusFieldElement)((CalculusFieldElement)aE2.multiply((FieldElement)((CalculusFieldElement)a2oaE.acos()))).subtract((FieldElement)((CalculusFieldElement)alpha2.multiply((FieldElement)((CalculusFieldElement)aE2ma22.sqrt()))));
            return (T)((CalculusFieldElement)((CalculusFieldElement)occultedSatOcculting.getField().getOne()).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)P1.add((FieldElement)P2)).divide((FieldElement)((CalculusFieldElement)aS2.multiply((FieldElement)((CalculusFieldElement)occultedSatOcculting.getPi())))))));
        }
        return (T)((CalculusFieldElement)occultedSatOcculting.getField().getOne());
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    private <T extends CalculusFieldElement<T>> T min(double d, T f) {
        return (T)(f.getReal() > d ? (CalculusFieldElement)((CalculusFieldElement)f.getField().getZero()).newInstance(d) : f);
    }

    private <T extends CalculusFieldElement<T>> T max(double d, T f) {
        return (T)(f.getReal() <= d ? (CalculusFieldElement)((CalculusFieldElement)f.getField().getZero()).newInstance(d) : f);
    }
}

