/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.radiation.IsotropicRadiationCNES95Convention;
import org.orekit.forces.radiation.IsotropicRadiationClassicalConvention;
import org.orekit.forces.radiation.IsotropicRadiationSingleCoefficient;
import org.orekit.forces.radiation.LightFluxModel;
import org.orekit.forces.radiation.RadiationForceModel;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class RadiationPressureModel
implements RadiationForceModel {
    private final LightFluxModel lightFluxModel;
    private final RadiationSensitive radiationSensitive;

    public RadiationPressureModel(LightFluxModel lightFluxModel, RadiationSensitive radiationSensitive) {
        this.lightFluxModel = lightFluxModel;
        this.radiationSensitive = radiationSensitive;
    }

    public RadiationSensitive getRadiationSensitive() {
        return this.radiationSensitive;
    }

    public LightFluxModel getLightFluxModel() {
        return this.lightFluxModel;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.radiationSensitive instanceof IsotropicRadiationClassicalConvention || this.radiationSensitive instanceof IsotropicRadiationCNES95Convention || this.radiationSensitive instanceof IsotropicRadiationSingleCoefficient;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        RadiationForceModel.super.init(initialState, target);
        this.lightFluxModel.init(initialState, target);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        RadiationForceModel.super.init(initialState, target);
        this.lightFluxModel.init(initialState, target);
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        Vector3D fluxVector = this.lightFluxModel.getLightFluxVector(s);
        return this.radiationSensitive.radiationPressureAcceleration(s, fluxVector, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldVector3D<T> fluxVector = this.lightFluxModel.getLightFluxVector(s);
        return this.radiationSensitive.radiationPressureAcceleration(s, (FieldVector3D)fluxVector, (CalculusFieldElement[])parameters);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.radiationSensitive.getRadiationParametersDrivers();
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        List<EventDetector> eventDetectors = this.lightFluxModel.getEclipseConditionsDetector();
        return Stream.concat(RadiationForceModel.super.getEventDetectors(), eventDetectors.stream());
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        List<FieldEventDetector<T>> eventDetectors = this.lightFluxModel.getFieldEclipseConditionsDetector(field);
        return Stream.concat(RadiationForceModel.super.getFieldEventDetectors(field), eventDetectors.stream());
    }
}

