/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class IsotropicRadiationSingleCoefficient
implements RadiationSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final List<ParameterDriver> radiationParametersDrivers = new ArrayList<ParameterDriver>(2);
    private final double crossSection;

    public IsotropicRadiationSingleCoefficient(double crossSection, double cr) {
        this(crossSection, cr, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public IsotropicRadiationSingleCoefficient(double crossSection, double cr, double crMin, double crMax) {
        this.radiationParametersDrivers.add(new ParameterDriver("global radiation factor", 1.0, this.SCALE, 0.0, Double.POSITIVE_INFINITY));
        this.radiationParametersDrivers.add(new ParameterDriver("reflection coefficient", cr, this.SCALE, crMin, crMax));
        this.crossSection = crossSection;
    }

    @Override
    public List<ParameterDriver> getRadiationParametersDrivers() {
        return Collections.unmodifiableList(this.radiationParametersDrivers);
    }

    @Override
    public Vector3D radiationPressureAcceleration(SpacecraftState state, Vector3D flux, double[] parameters) {
        double cr = parameters[1];
        return new Vector3D(parameters[0] * this.crossSection * cr / state.getMass(), flux);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldSpacecraftState<T> state, FieldVector3D<T> flux, T[] parameters) {
        T cr = parameters[1];
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)state.getMass().reciprocal()).multiply(parameters[0])).multiply(this.crossSection)).multiply(cr), flux);
    }
}

