/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class IsotropicRadiationClassicalConvention
implements RadiationSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final List<ParameterDriver> parameterDrivers = new ArrayList<ParameterDriver>(3);
    private final double crossSection;

    public IsotropicRadiationClassicalConvention(double crossSection, double ca, double cs) {
        this.parameterDrivers.add(new ParameterDriver("global radiation factor", 1.0, this.SCALE, 0.0, Double.POSITIVE_INFINITY));
        this.parameterDrivers.add(new ParameterDriver("absorption coefficient", ca, this.SCALE, 0.0, 1.0));
        this.parameterDrivers.add(new ParameterDriver("reflection coefficient", cs, this.SCALE, 0.0, 1.0));
        this.crossSection = crossSection;
    }

    @Override
    public List<ParameterDriver> getRadiationParametersDrivers() {
        return Collections.unmodifiableList(this.parameterDrivers);
    }

    @Override
    public Vector3D radiationPressureAcceleration(SpacecraftState state, Vector3D flux, double[] parameters) {
        double ca = parameters[1];
        double cs = parameters[2];
        double kP = parameters[0] * this.crossSection * (1.0 + 4.0 * (1.0 - ca - cs) / 9.0);
        return new Vector3D(kP / state.getMass(), flux);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldSpacecraftState<T> state, FieldVector3D<T> flux, T[] parameters) {
        T ca = parameters[1];
        T cs = parameters[2];
        CalculusFieldElement kP = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ca.add(cs)).negate()).add(1.0)).multiply(0.4444444444444444)).add(1.0)).multiply(parameters[0])).multiply(this.crossSection);
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)state.getMass().reciprocal()).multiply((FieldElement)kP), flux);
    }
}

