/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.forces.radiation.AbstractRadiationForceModel;
import org.orekit.frames.FramesFactory;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class ECOM2
extends AbstractRadiationForceModel {
    public static final String ECOM_COEFFICIENT = "ECOM coefficient";
    private static final double MIN_VALUE = Double.NEGATIVE_INFINITY;
    private static final double MAX_VALUE = Double.POSITIVE_INFINITY;
    private final double SCALE = FastMath.scalb((double)1.0, (int)-22);
    private final int nD;
    private final int nB;
    private final List<ParameterDriver> coefficients;
    private final ExtendedPVCoordinatesProvider sun;

    @DefaultDataContext
    public ECOM2(int nD, int nB, double value, ExtendedPVCoordinatesProvider sun, double equatorialRadius) {
        super(sun, new OneAxisEllipsoid(equatorialRadius, 0.0, FramesFactory.getGCRF()));
        int i;
        this.nB = nB;
        this.nD = nD;
        this.coefficients = new ArrayList<ParameterDriver>(2 * (nD + nB) + 3);
        this.coefficients.add(new ParameterDriver("ECOM coefficient B0", value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        for (i = 1; i < nB + 1; ++i) {
            this.coefficients.add(new ParameterDriver("ECOM coefficient Bcos" + Integer.toString(i - 1), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        }
        for (i = nB + 1; i < 2 * nB + 1; ++i) {
            this.coefficients.add(new ParameterDriver("ECOM coefficient Bsin" + Integer.toString(i - (nB + 1)), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        }
        this.coefficients.add(2 * nB + 1, new ParameterDriver("ECOM coefficient D0", value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        for (i = 2 * nB + 2; i < 2 * nB + 2 + nD; ++i) {
            this.coefficients.add(new ParameterDriver("ECOM coefficient Dcos" + Integer.toString(i - (2 * nB + 2)), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        }
        for (i = 2 * nB + 2 + nD; i < 2 * (nB + nD) + 2; ++i) {
            this.coefficients.add(new ParameterDriver("ECOM coefficient Dsin" + Integer.toString(i - (2 * nB + nD + 2)), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        }
        this.coefficients.add(new ParameterDriver("ECOM coefficient Y0", value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        this.coefficients.forEach(parameter -> parameter.setSelected(true));
        this.sun = sun;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        Vector3D satPos = s.getPosition();
        Vector3D sunPos = this.sun.getPosition(s.getDate(), s.getFrame());
        Vector3D Z = s.getPVCoordinates().getMomentum();
        Vector3D Y = (Vector3D)Z.crossProduct((Vector)sunPos).normalize();
        Vector3D X = (Vector3D)Y.crossProduct((Vector)Z).normalize();
        Vector3D eD = (Vector3D)sunPos.subtract((Vector)satPos).normalize();
        Vector3D eY = (Vector3D)eD.crossProduct((Vector)satPos).normalize();
        Vector3D eB = eD.crossProduct((Vector)eY);
        double delta_u = FastMath.atan2((double)satPos.dotProduct((Vector)Y), (double)satPos.dotProduct((Vector)X));
        double b_u = parameters[0];
        for (int i = 1; i < this.nB + 1; ++i) {
            SinCos sc = FastMath.sinCos((double)((double)(2 * i - 1) * delta_u));
            b_u += parameters[i] * sc.cos() + parameters[i + this.nB] * sc.sin();
        }
        double d_u = parameters[2 * this.nB + 1];
        for (int i = 1; i < this.nD + 1; ++i) {
            SinCos sc = FastMath.sinCos((double)((double)(2 * i) * delta_u));
            d_u += parameters[2 * this.nB + 1 + i] * sc.cos() + parameters[2 * this.nB + 1 + i + this.nD] * sc.sin();
        }
        return new Vector3D(d_u, eD, parameters[2 * (this.nD + this.nB) + 2], eY, b_u, eB);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldVector3D<T> satPos = s.getPosition();
        FieldVector3D<T> sunPos = this.sun.getPosition(s.getDate(), s.getFrame());
        FieldVector3D Z = s.getPVCoordinates().getMomentum();
        FieldVector3D Y = Z.crossProduct(sunPos).normalize();
        FieldVector3D X = Y.crossProduct(Z).normalize();
        FieldVector3D eD = sunPos.subtract(satPos).normalize();
        FieldVector3D eY = eD.crossProduct(satPos).normalize();
        FieldVector3D eB = eD.crossProduct(eY);
        CalculusFieldElement delta_u = FastMath.atan2((CalculusFieldElement)satPos.dotProduct(Y), (CalculusFieldElement)satPos.dotProduct(X));
        Object b_u = parameters[0];
        for (int i = 1; i < this.nB + 1; ++i) {
            FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)delta_u.multiply(2 * i - 1)));
            b_u = (CalculusFieldElement)((CalculusFieldElement)b_u.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply(parameters[i])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply(parameters[i + this.nB])));
        }
        Object d_u = parameters[2 * this.nB + 1];
        for (int i = 1; i < this.nD + 1; ++i) {
            FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)delta_u.multiply(2 * i)));
            d_u = (CalculusFieldElement)((CalculusFieldElement)d_u.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply(parameters[2 * this.nB + 1 + i])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply(parameters[2 * this.nB + 1 + i + this.nD])));
        }
        return new FieldVector3D(d_u, eD, parameters[2 * (this.nD + this.nB) + 2], eY, b_u, eB);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.unmodifiableList(this.coefficients);
    }
}

