/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.radiation.AbstractSolarLightFluxModel;
import org.orekit.propagation.events.CylindricalShadowEclipseDetector;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldCylindricalShadowEclipseDetector;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;
import org.orekit.utils.ExtendedPositionProvider;

public class CylindricallyShadowedLightFluxModel
extends AbstractSolarLightFluxModel {
    private static final double CYLINDRICAL_ECLIPSE_MAX_CHECK = 100.0;
    private static final double CYLINDRICAL_ECLIPSE_THRESHOLD = 1.0E-7;

    public CylindricallyShadowedLightFluxModel(double kRef, ExtendedPositionProvider occultedBody, double occultingBodyRadius, EventDetectionSettings eventDetectionSettings) {
        super(kRef, occultedBody, occultingBodyRadius, eventDetectionSettings);
    }

    public CylindricallyShadowedLightFluxModel(double kRef, ExtendedPositionProvider occultedBody, double occultingBodyRadius) {
        this(kRef, occultedBody, occultingBodyRadius, CylindricallyShadowedLightFluxModel.getDefaultEclipseDetectionSettings());
    }

    public CylindricallyShadowedLightFluxModel(ExtendedPositionProvider occultedBody, double occultingBodyRadius) {
        super(occultedBody, occultingBodyRadius, CylindricallyShadowedLightFluxModel.getDefaultEclipseDetectionSettings());
    }

    public static EventDetectionSettings getDefaultEclipseDetectionSettings() {
        return new EventDetectionSettings(100.0, 1.0E-7, 100);
    }

    @Override
    protected double getLightingRatio(Vector3D position, Vector3D occultedBodyPosition) {
        double distanceToCylinderAxis;
        Vector3D occultedBodyDirection = (Vector3D)occultedBodyPosition.normalize();
        double dotProduct = position.dotProduct((Vector)occultedBodyDirection);
        if (dotProduct < 0.0 && (distanceToCylinderAxis = position.subtract((Vector)occultedBodyDirection.scalarMultiply(dotProduct)).getNorm()) <= this.getOccultingBodyRadius()) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T getLightingRatio(FieldVector3D<T> position, FieldVector3D<T> occultedBodyPosition) {
        CalculusFieldElement distanceToCylinderAxis;
        Field field = position.getX().getField();
        FieldVector3D occultedBodyDirection = occultedBodyPosition.normalize();
        CalculusFieldElement dotProduct = position.dotProduct(occultedBodyDirection);
        if (dotProduct.getReal() < 0.0 && (distanceToCylinderAxis = position.subtract(occultedBodyDirection.scalarMultiply(dotProduct)).getNorm()).getReal() <= this.getOccultingBodyRadius()) {
            return (T)((CalculusFieldElement)field.getZero());
        }
        return (T)((CalculusFieldElement)field.getOne());
    }

    @Override
    public List<EventDetector> getEclipseConditionsDetector() {
        ArrayList<EventDetector> detectors = new ArrayList<EventDetector>();
        detectors.add((EventDetector)this.createCylindricalShadowEclipseDetector().withDetectionSettings(this.getEventDetectionSettings()));
        return detectors;
    }

    private CylindricalShadowEclipseDetector createCylindricalShadowEclipseDetector() {
        return new CylindricalShadowEclipseDetector(this.getOccultedBody(), this.getOccultingBodyRadius(), new ResetDerivativesOnEvent());
    }

    @Override
    public <T extends CalculusFieldElement<T>> List<FieldEventDetector<T>> getFieldEclipseConditionsDetector(Field<T> field) {
        ArrayList<FieldEventDetector<T>> detectors = new ArrayList<FieldEventDetector<T>>();
        FieldEventDetectionSettings<T> detectionSettings = new FieldEventDetectionSettings<T>(field, this.getEventDetectionSettings());
        detectors.add((FieldEventDetector<T>)this.createFieldCylindricalShadowEclipseDetector(field).withDetectionSettings(detectionSettings));
        return detectors;
    }

    private <T extends CalculusFieldElement<T>> FieldCylindricalShadowEclipseDetector<T> createFieldCylindricalShadowEclipseDetector(Field<T> field) {
        CalculusFieldElement occultingBodyRadiusAsField = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(this.getOccultingBodyRadius());
        return new FieldCylindricalShadowEclipseDetector<CalculusFieldElement>(this.getOccultedBody(), occultingBodyRadiusAsField, new FieldResetDerivativesOnEvent());
    }
}

