/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.radiation.AbstractSolarLightFluxModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPositionProvider;

public class ConicallyShadowedLightFluxModel
extends AbstractSolarLightFluxModel {
    private static final double CONICAL_ECLIPSE_MAX_CHECK = 60.0;
    private static final double CONICAL_ECLIPSE_THRESHOLD = 1.0E-7;
    private final double occultedBodyRadius;
    private AbsoluteDate lastDate;
    private Frame propagationFrame;
    private Vector3D lastPosition;

    public ConicallyShadowedLightFluxModel(double kRef, double occultedBodyRadius, ExtendedPositionProvider occultedBody, double occultingBodyRadius, EventDetectionSettings eventDetectionSettings) {
        super(kRef, occultedBody, occultingBodyRadius, eventDetectionSettings);
        this.occultedBodyRadius = occultedBodyRadius;
    }

    public ConicallyShadowedLightFluxModel(double kRef, double occultedBodyRadius, ExtendedPositionProvider occultedBody, double occultingBodyRadius) {
        this(kRef, occultedBodyRadius, occultedBody, occultingBodyRadius, ConicallyShadowedLightFluxModel.getDefaultEclipseDetectionSettings());
    }

    public ConicallyShadowedLightFluxModel(double occultedBodyRadius, ExtendedPositionProvider occultedBody, double occultingBodyRadius) {
        super(occultedBody, occultingBodyRadius, ConicallyShadowedLightFluxModel.getDefaultEclipseDetectionSettings());
        this.occultedBodyRadius = occultedBodyRadius;
    }

    public static EventDetectionSettings getDefaultEclipseDetectionSettings() {
        return new EventDetectionSettings(60.0, 1.0E-7, 100);
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate targetDate) {
        super.init(initialState, targetDate);
        this.lastDate = initialState.getDate();
        this.propagationFrame = initialState.getFrame();
        this.lastPosition = this.getOccultedBodyPosition(this.lastDate, this.propagationFrame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> targetDate) {
        super.init(initialState, targetDate);
        this.lastDate = initialState.getDate().toAbsoluteDate();
        this.propagationFrame = initialState.getFrame();
        this.lastPosition = this.getOccultedBodyPosition(initialState.getDate(), this.propagationFrame).toVector3D();
    }

    private Vector3D getOccultedBodyPosition(AbsoluteDate date) {
        if (!this.lastDate.isEqualTo(date)) {
            this.lastPosition = this.getOccultedBodyPosition(date, this.propagationFrame);
            this.lastDate = date;
        }
        return this.lastPosition;
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getOccultedBodyPosition(FieldAbsoluteDate<T> fieldDate) {
        if (fieldDate.hasZeroField()) {
            AbsoluteDate date = fieldDate.toAbsoluteDate();
            if (!this.lastDate.isEqualTo(date)) {
                this.lastPosition = this.getOccultedBodyPosition(date, this.propagationFrame);
                this.lastDate = date;
            }
            return new FieldVector3D(fieldDate.getField(), this.lastPosition);
        }
        return this.getOccultedBodyPosition(fieldDate, this.propagationFrame);
    }

    @Override
    protected double getLightingRatio(Vector3D position, Vector3D occultedBodyPosition) {
        double distanceSun = occultedBodyPosition.getNorm();
        double squaredDistance = position.getNormSq();
        Vector3D occultedBodyDirection = (Vector3D)occultedBodyPosition.normalize();
        double s0 = -position.dotProduct((Vector)occultedBodyDirection);
        if (s0 > 0.0) {
            double l = FastMath.sqrt((double)(squaredDistance - s0 * s0));
            double sinf2 = (this.occultedBodyRadius - this.getOccultingBodyRadius()) / distanceSun;
            double l2 = (s0 * sinf2 - this.getOccultingBodyRadius()) / FastMath.sqrt((double)(1.0 - sinf2 * sinf2));
            if (FastMath.abs((double)l2) - l >= 0.0) {
                return 0.0;
            }
            double sinf1 = (this.occultedBodyRadius + this.getOccultingBodyRadius()) / distanceSun;
            double l1 = (s0 * sinf1 + this.getOccultingBodyRadius()) / FastMath.sqrt((double)(1.0 - sinf1 * sinf1));
            if (l1 - l > 0.0) {
                Vector3D relativePosition = occultedBodyPosition.subtract((Vector)position);
                double relativeDistance = relativePosition.getNorm();
                double a = FastMath.asin((double)(this.occultedBodyRadius / relativeDistance));
                double a2 = a * a;
                double r = FastMath.sqrt((double)squaredDistance);
                double b = FastMath.asin((double)(this.getOccultingBodyRadius() / r));
                double c = FastMath.acos((double)(-relativePosition.dotProduct((Vector)position) / (r * relativeDistance)));
                double x = (c * c + a2 - b * b) / (2.0 * c);
                double y = FastMath.sqrt((double)FastMath.max((double)0.0, (double)(a2 - x * x)));
                double arcCosXOverA = FastMath.acos((double)FastMath.max((double)-1.0, (double)(x / a)));
                double intermediate = (arcCosXOverA + (b * b * FastMath.acos((double)((c - x) / b)) - c * y) / a2) / Math.PI;
                return 1.0 - intermediate;
            }
        }
        return 1.0;
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T getLightingRatio(FieldVector3D<T> position, FieldVector3D<T> occultedBodyPosition) {
        Field field = position.getX().getField();
        CalculusFieldElement distanceSun = occultedBodyPosition.getNorm();
        CalculusFieldElement squaredDistance = position.getNormSq();
        FieldVector3D occultedBodyDirection = occultedBodyPosition.normalize();
        CalculusFieldElement s0 = (CalculusFieldElement)position.dotProduct(occultedBodyDirection).negate();
        if (s0.getReal() > 0.0) {
            CalculusFieldElement reciprocalDistanceSun = (CalculusFieldElement)distanceSun.reciprocal();
            CalculusFieldElement sinf2 = (CalculusFieldElement)reciprocalDistanceSun.multiply(this.occultedBodyRadius - this.getOccultingBodyRadius());
            CalculusFieldElement l2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s0.multiply((FieldElement)sinf2)).subtract(this.getOccultingBodyRadius())).divide((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinf2.square()).negate()).add(1.0))));
            CalculusFieldElement l = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)squaredDistance.subtract((FieldElement)((CalculusFieldElement)s0.square()))));
            if (((CalculusFieldElement)FastMath.abs((CalculusFieldElement)l2).subtract((FieldElement)l)).getReal() >= 0.0) {
                return (T)((CalculusFieldElement)field.getZero());
            }
            CalculusFieldElement sinf1 = (CalculusFieldElement)reciprocalDistanceSun.multiply(this.occultedBodyRadius + this.getOccultingBodyRadius());
            CalculusFieldElement l1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s0.multiply((FieldElement)sinf1)).add(this.getOccultingBodyRadius())).divide((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinf1.square()).negate()).add(1.0))));
            if (((CalculusFieldElement)l1.subtract((FieldElement)l)).getReal() > 0.0) {
                FieldVector3D relativePosition = occultedBodyPosition.subtract(position);
                CalculusFieldElement relativeDistance = relativePosition.getNorm();
                CalculusFieldElement a = FastMath.asin((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)relativeDistance.reciprocal()).multiply(this.occultedBodyRadius)));
                CalculusFieldElement a2 = (CalculusFieldElement)a.square();
                CalculusFieldElement r = FastMath.sqrt((CalculusFieldElement)squaredDistance);
                CalculusFieldElement b = FastMath.asin((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.reciprocal()).multiply(this.getOccultingBodyRadius())));
                CalculusFieldElement b2 = (CalculusFieldElement)b.square();
                CalculusFieldElement c = FastMath.acos((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)relativePosition.dotProduct(position).negate()).divide((FieldElement)((CalculusFieldElement)r.multiply((FieldElement)relativeDistance)))));
                CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c.square()).add((FieldElement)a2)).subtract((FieldElement)b2)).divide((FieldElement)((CalculusFieldElement)c.multiply(2)));
                CalculusFieldElement x2 = (CalculusFieldElement)x.square();
                CalculusFieldElement y = a2.getReal() - x2.getReal() <= 0.0 ? (CalculusFieldElement)s0.getField().getZero() : FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)a2.subtract((FieldElement)x2)));
                CalculusFieldElement arcCosXOverA = x.getReal() / a.getReal() < -1.0 ? (CalculusFieldElement)((CalculusFieldElement)s0.getPi()).negate() : FastMath.acos((CalculusFieldElement)((CalculusFieldElement)x.divide((FieldElement)a)));
                CalculusFieldElement intermediate = (CalculusFieldElement)arcCosXOverA.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)b2.multiply((FieldElement)FastMath.acos((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c.subtract((FieldElement)x)).divide((FieldElement)b))))).subtract((FieldElement)((CalculusFieldElement)c.multiply((FieldElement)y)))).divide((FieldElement)a2)));
                return (T)((CalculusFieldElement)((CalculusFieldElement)intermediate.divide(-Math.PI)).add(1.0));
            }
        }
        return (T)((CalculusFieldElement)field.getOne());
    }

    @Override
    public List<EventDetector> getEclipseConditionsDetector() {
        ArrayList<EventDetector> detectors = new ArrayList<EventDetector>();
        detectors.add(this.createUmbraEclipseDetector());
        detectors.add(this.createPenumbraEclipseDetector());
        return detectors;
    }

    private InternalEclipseDetector createUmbraEclipseDetector() {
        return new InternalEclipseDetector(){

            @Override
            public double g(SpacecraftState s) {
                Vector3D position = s.getPosition();
                Vector3D occultedBodyPosition = ConicallyShadowedLightFluxModel.this.getOccultedBodyPosition(s.getDate());
                Vector3D occultedBodyDirection = (Vector3D)occultedBodyPosition.normalize();
                double s0 = -position.dotProduct((Vector)occultedBodyDirection);
                double distanceSun = occultedBodyPosition.getNorm();
                double squaredDistance = position.getNormSq();
                double sinf2 = (ConicallyShadowedLightFluxModel.this.occultedBodyRadius - ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius()) / distanceSun;
                double l = FastMath.sqrt((double)(squaredDistance - s0 * s0));
                double l2 = (s0 * sinf2 - ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius()) / FastMath.sqrt((double)(1.0 - sinf2 * sinf2));
                return FastMath.abs((double)l2) / l - 1.0;
            }
        };
    }

    private InternalEclipseDetector createPenumbraEclipseDetector() {
        return new InternalEclipseDetector(){

            @Override
            public double g(SpacecraftState s) {
                Vector3D position = s.getPosition();
                Vector3D occultedBodyPosition = ConicallyShadowedLightFluxModel.this.getOccultedBodyPosition(s.getDate());
                Vector3D occultedBodyDirection = (Vector3D)occultedBodyPosition.normalize();
                double s0 = -position.dotProduct((Vector)occultedBodyDirection);
                double distanceSun = occultedBodyPosition.getNorm();
                double squaredDistance = position.getNormSq();
                double l = FastMath.sqrt((double)(squaredDistance - s0 * s0));
                double sinf1 = (ConicallyShadowedLightFluxModel.this.occultedBodyRadius + ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius()) / distanceSun;
                double l1 = (s0 * sinf1 + ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius()) / FastMath.sqrt((double)(1.0 - sinf1 * sinf1));
                return l1 / l - 1.0;
            }
        };
    }

    @Override
    public <T extends CalculusFieldElement<T>> List<FieldEventDetector<T>> getFieldEclipseConditionsDetector(Field<T> field) {
        ArrayList<FieldEventDetector<T>> detectors = new ArrayList<FieldEventDetector<T>>();
        FieldEventDetectionSettings<T> detectionSettings = new FieldEventDetectionSettings<T>(field, this.getEventDetectionSettings());
        detectors.add(this.createFieldUmbraEclipseDetector(detectionSettings));
        detectors.add(this.createFieldPenumbraEclipseDetector(detectionSettings));
        return detectors;
    }

    private <T extends CalculusFieldElement<T>> FieldInternalEclipseDetector<T> createFieldUmbraEclipseDetector(FieldEventDetectionSettings<T> detectionSettings) {
        return new FieldInternalEclipseDetector<T>(detectionSettings){

            @Override
            public T g(FieldSpacecraftState<T> s) {
                FieldVector3D position = s.getPosition();
                FieldVector3D occultedBodyPosition = ConicallyShadowedLightFluxModel.this.getOccultedBodyPosition(s.getDate());
                FieldVector3D occultedBodyDirection = occultedBodyPosition.normalize();
                CalculusFieldElement s0 = (CalculusFieldElement)position.dotProduct(occultedBodyDirection).negate();
                CalculusFieldElement distanceSun = occultedBodyPosition.getNorm();
                CalculusFieldElement squaredDistance = position.getNormSq();
                CalculusFieldElement reciprocalDistanceSun = (CalculusFieldElement)distanceSun.reciprocal();
                CalculusFieldElement sinf1 = (CalculusFieldElement)reciprocalDistanceSun.multiply(ConicallyShadowedLightFluxModel.this.occultedBodyRadius + ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius());
                CalculusFieldElement l1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s0.multiply((FieldElement)sinf1)).add(ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius())).divide((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinf1.square()).negate()).add(1.0))));
                CalculusFieldElement l = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)squaredDistance.subtract((FieldElement)((CalculusFieldElement)s0.square()))));
                return (CalculusFieldElement)((CalculusFieldElement)l1.divide((FieldElement)l)).subtract(1.0);
            }
        };
    }

    private <T extends CalculusFieldElement<T>> FieldInternalEclipseDetector<T> createFieldPenumbraEclipseDetector(FieldEventDetectionSettings<T> detectionSettings) {
        return new FieldInternalEclipseDetector<T>(detectionSettings){

            @Override
            public T g(FieldSpacecraftState<T> s) {
                FieldVector3D position = s.getPosition();
                FieldVector3D occultedBodyPosition = ConicallyShadowedLightFluxModel.this.getOccultedBodyPosition(s.getDate());
                FieldVector3D occultedBodyDirection = occultedBodyPosition.normalize();
                CalculusFieldElement s0 = (CalculusFieldElement)position.dotProduct(occultedBodyDirection).negate();
                CalculusFieldElement distanceSun = occultedBodyPosition.getNorm();
                CalculusFieldElement squaredDistance = position.getNormSq();
                CalculusFieldElement reciprocalDistanceSun = (CalculusFieldElement)distanceSun.reciprocal();
                CalculusFieldElement sinf2 = (CalculusFieldElement)reciprocalDistanceSun.multiply(ConicallyShadowedLightFluxModel.this.occultedBodyRadius - ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius());
                CalculusFieldElement l2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s0.multiply((FieldElement)sinf2)).subtract(ConicallyShadowedLightFluxModel.this.getOccultingBodyRadius())).divide((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinf2.square()).negate()).add(1.0))));
                CalculusFieldElement l = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)squaredDistance.subtract((FieldElement)((CalculusFieldElement)s0.square()))));
                return (CalculusFieldElement)((CalculusFieldElement)FastMath.abs((CalculusFieldElement)l2).divide((FieldElement)l)).subtract(1.0);
            }
        };
    }

    private static abstract class FieldInternalEclipseDetector<T extends CalculusFieldElement<T>>
    implements FieldEventDetector<T> {
        private final FieldResetDerivativesOnEvent<T> handler = new FieldResetDerivativesOnEvent();
        private final FieldEventDetectionSettings<T> fieldEventDetectionSettings;

        FieldInternalEclipseDetector(FieldEventDetectionSettings<T> fieldEventDetectionSettings) {
            this.fieldEventDetectionSettings = fieldEventDetectionSettings;
        }

        @Override
        public FieldEventDetectionSettings<T> getDetectionSettings() {
            return this.fieldEventDetectionSettings;
        }

        @Override
        public T getThreshold() {
            return this.getDetectionSettings().getThreshold();
        }

        @Override
        public FieldAdaptableInterval<T> getMaxCheckInterval() {
            return this.getDetectionSettings().getMaxCheckInterval();
        }

        @Override
        public int getMaxIterationCount() {
            return this.getDetectionSettings().getMaxIterationCount();
        }

        @Override
        public FieldEventHandler<T> getHandler() {
            return this.handler;
        }
    }

    private abstract class InternalEclipseDetector
    implements EventDetector {
        private final ResetDerivativesOnEvent handler = new ResetDerivativesOnEvent();

        InternalEclipseDetector() {
        }

        @Override
        public EventDetectionSettings getDetectionSettings() {
            return ConicallyShadowedLightFluxModel.this.getEventDetectionSettings();
        }

        @Override
        public double getThreshold() {
            return this.getDetectionSettings().getThreshold();
        }

        @Override
        public AdaptableInterval getMaxCheckInterval() {
            return this.getDetectionSettings().getMaxCheckInterval();
        }

        @Override
        public int getMaxIterationCount() {
            return this.getDetectionSettings().getMaxIterationCount();
        }

        @Override
        public EventHandler getHandler() {
            return this.handler;
        }
    }
}

