/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.radiation.AbstractLightFluxModel;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.utils.ExtendedPositionProvider;

public abstract class AbstractSolarLightFluxModel
extends AbstractLightFluxModel {
    private final double occultingBodyRadius;
    private final double kRef;
    private final EventDetectionSettings eventDetectionSettings;

    protected AbstractSolarLightFluxModel(double kRef, ExtendedPositionProvider occultedBody, double occultingBodyRadius, EventDetectionSettings eventDetectionSettings) {
        super(occultedBody);
        this.kRef = kRef;
        this.occultingBodyRadius = occultingBodyRadius;
        this.eventDetectionSettings = eventDetectionSettings;
    }

    protected AbstractSolarLightFluxModel(ExtendedPositionProvider occultedBody, double occultingBodyRadius, EventDetectionSettings eventDetectionSettings) {
        this(4.56E-6 * FastMath.pow((double)1.4959787E11, (int)2), occultedBody, occultingBodyRadius, eventDetectionSettings);
    }

    public double getOccultingBodyRadius() {
        return this.occultingBodyRadius;
    }

    public EventDetectionSettings getEventDetectionSettings() {
        return this.eventDetectionSettings;
    }

    @Override
    protected Vector3D getUnoccultedFluxVector(Vector3D relativePosition) {
        double squaredRadius = relativePosition.getNormSq();
        double factor = this.kRef / (squaredRadius * FastMath.sqrt((double)squaredRadius));
        return relativePosition.scalarMultiply(factor);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getUnoccultedFluxVector(FieldVector3D<T> relativePosition) {
        CalculusFieldElement squaredRadius = relativePosition.getNormSq();
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)squaredRadius.multiply((FieldElement)((CalculusFieldElement)squaredRadius.sqrt()))).reciprocal()).multiply(this.kRef);
        return relativePosition.scalarMultiply(factor);
    }
}

