/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.forces.radiation.RadiationForceModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.events.EclipseDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEclipseDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ExtendedPVCoordinatesProviderAdapter;
import org.orekit.utils.OccultationEngine;

public abstract class AbstractRadiationForceModel
implements RadiationForceModel {
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private static final double ECLIPSE_MAX_CHECK = 60.0;
    private static final double ECLIPSE_THRESHOLD = 1.0E-7;
    private static final double SPHERICAL_BODY_FLATNESS = 0.0;
    private static final String OCCULTING_PREFIX = "occulting-";
    private final List<OccultationEngine> occultingBodies = new ArrayList<OccultationEngine>(2);

    protected AbstractRadiationForceModel(ExtendedPVCoordinatesProvider sun, OneAxisEllipsoid centralBody) {
        this.occultingBodies.add(new OccultationEngine(sun, 6.957E8, centralBody));
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        EventDetector[] detectors = new EventDetector[2 * this.occultingBodies.size()];
        for (int i = 0; i < this.occultingBodies.size(); ++i) {
            OccultationEngine occulting = this.occultingBodies.get(i);
            detectors[2 * i] = ((EclipseDetector)((EclipseDetector)new EclipseDetector(occulting).withUmbra().withMargin(-1.0E-10).withMaxCheck(60.0)).withThreshold(1.0E-7)).withHandler(new ResetDerivativesOnEvent());
            detectors[2 * i + 1] = ((EclipseDetector)((EclipseDetector)new EclipseDetector(occulting).withPenumbra().withMargin(1.0E-10).withMaxCheck(60.0)).withThreshold(1.0E-7)).withHandler(new ResetDerivativesOnEvent());
        }
        return Stream.concat(Stream.of(detectors), RadiationForceModel.super.getEventDetectors());
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldEventDetector[] detectors = (FieldEventDetector[])Array.newInstance(FieldEventDetector.class, 2 * this.occultingBodies.size());
        for (int i = 0; i < this.occultingBodies.size(); ++i) {
            OccultationEngine occulting = this.occultingBodies.get(i);
            detectors[2 * i] = ((FieldEclipseDetector)((FieldEclipseDetector)new FieldEclipseDetector<T>(field, occulting).withUmbra().withMargin((CalculusFieldElement)zero.newInstance(-1.0E-10)).withMaxCheck(60.0)).withThreshold((CalculusFieldElement)zero.newInstance(1.0E-7))).withHandler(new FieldResetDerivativesOnEvent());
            detectors[2 * i + 1] = ((FieldEclipseDetector)((FieldEclipseDetector)new FieldEclipseDetector<T>(field, occulting).withPenumbra().withMargin((CalculusFieldElement)zero.newInstance(1.0E-10)).withMaxCheck(60.0)).withThreshold((CalculusFieldElement)zero.newInstance(1.0E-7))).withHandler(new FieldResetDerivativesOnEvent());
        }
        return Stream.concat(Stream.of(detectors), RadiationForceModel.super.getFieldEventDetectors(field));
    }

    protected double[] getGeneralEclipseAngles(Vector3D position, Vector3D occultingPosition, double occultingRadius, Vector3D occultedPosition, double occultedRadius) {
        double[] angle = new double[3];
        Vector3D satOccultedVector = occultedPosition.subtract((Vector)position);
        Vector3D satOccultingVector = occultingPosition.subtract((Vector)position);
        angle[0] = Vector3D.angle((Vector3D)satOccultedVector, (Vector3D)satOccultingVector);
        angle[1] = FastMath.asin((double)(occultingRadius / satOccultingVector.getNorm()));
        angle[2] = FastMath.asin((double)(occultedRadius / satOccultedVector.getNorm()));
        return angle;
    }

    protected <T extends CalculusFieldElement<T>> T[] getGeneralEclipseAngles(FieldVector3D<T> position, FieldVector3D<T> occultingPosition, T occultingRadius, FieldVector3D<T> occultedPosition, T occultedRadius) {
        CalculusFieldElement[] angle = (CalculusFieldElement[])MathArrays.buildArray((Field)position.getX().getField(), (int)3);
        FieldVector3D satOccultedVector = occultedPosition.subtract(position);
        FieldVector3D satOccultingVector = occultingPosition.subtract(position);
        angle[0] = FieldVector3D.angle((FieldVector3D)satOccultedVector, (FieldVector3D)satOccultingVector);
        angle[1] = (CalculusFieldElement)((CalculusFieldElement)occultingRadius.divide((FieldElement)satOccultingVector.getNorm())).asin();
        angle[2] = (CalculusFieldElement)((CalculusFieldElement)occultedRadius.divide((FieldElement)satOccultedVector.getNorm())).asin();
        return angle;
    }

    public void addOccultingBody(ExtendedPVCoordinatesProvider provider, double radius) {
        Frame parent = this.occultingBodies.get(0).getOcculting().getBodyFrame();
        while (!parent.isPseudoInertial()) {
            parent = parent.getParent();
        }
        ExtendedPVCoordinatesProviderAdapter inertiallyOrientedBodyFrame = new ExtendedPVCoordinatesProviderAdapter(parent, provider, OCCULTING_PREFIX + this.occultingBodies.size());
        OneAxisEllipsoid sphericalOccultingBody = new OneAxisEllipsoid(radius, 0.0, inertiallyOrientedBodyFrame);
        this.addOccultingBody(sphericalOccultingBody);
    }

    public void addOccultingBody(OneAxisEllipsoid occulting) {
        OccultationEngine central = this.occultingBodies.get(0);
        OccultationEngine additional = new OccultationEngine(central.getOcculted(), central.getOccultedRadius(), occulting);
        this.occultingBodies.add(additional);
    }

    public List<OccultationEngine> getOccultingBodies() {
        return Collections.unmodifiableList(this.occultingBodies);
    }
}

