/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.radiation.LightFluxModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPositionProvider;

public abstract class AbstractLightFluxModel
implements LightFluxModel {
    private final ExtendedPositionProvider occultedBody;

    protected AbstractLightFluxModel(ExtendedPositionProvider occultedBody) {
        this.occultedBody = occultedBody;
    }

    public ExtendedPositionProvider getOccultedBody() {
        return this.occultedBody;
    }

    @Override
    public Vector3D getLightFluxVector(SpacecraftState state) {
        Vector3D lightSourcePosition;
        Vector3D position = state.getPosition();
        double lightingRatio = this.getLightingRatio(position, lightSourcePosition = this.getOccultedBodyPosition(state.getDate(), state.getFrame()));
        if (lightingRatio != 0.0) {
            Vector3D relativePosition = position.subtract((Vector)lightSourcePosition);
            Vector3D unoccultedFlux = this.getUnoccultedFluxVector(relativePosition);
            return unoccultedFlux.scalarMultiply(lightingRatio);
        }
        return Vector3D.ZERO;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getLightFluxVector(FieldSpacecraftState<T> state) {
        FieldVector3D<T> position = state.getPosition();
        FieldVector3D<T> lightSourcePosition = this.getOccultedBodyPosition(state.getDate(), state.getFrame());
        T lightingRatio = this.getLightingRatio(position, lightSourcePosition);
        FieldVector3D relativePosition = position.subtract(lightSourcePosition);
        FieldVector3D<T> unoccultedFlux = this.getUnoccultedFluxVector(relativePosition);
        return unoccultedFlux.scalarMultiply(lightingRatio);
    }

    protected Vector3D getOccultedBodyPosition(AbsoluteDate date, Frame frame) {
        return this.occultedBody.getPosition(date, frame);
    }

    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getOccultedBodyPosition(FieldAbsoluteDate<T> date, Frame frame) {
        return this.occultedBody.getPosition(date, frame);
    }

    protected abstract Vector3D getUnoccultedFluxVector(Vector3D var1);

    protected abstract <T extends CalculusFieldElement<T>> FieldVector3D<T> getUnoccultedFluxVector(FieldVector3D<T> var1);

    public double getLightingRatio(SpacecraftState state) {
        Vector3D position = state.getPosition();
        Vector3D lightSourcePosition = this.getOccultedBodyPosition(state.getDate(), state.getFrame());
        return this.getLightingRatio(position, lightSourcePosition);
    }

    protected abstract double getLightingRatio(Vector3D var1, Vector3D var2);

    public <T extends CalculusFieldElement<T>> T getLightingRatio(FieldSpacecraftState<T> state) {
        FieldVector3D<T> position = state.getPosition();
        FieldVector3D<T> lightSourcePosition = this.getOccultedBodyPosition(state.getDate(), state.getFrame());
        return this.getLightingRatio(position, lightSourcePosition);
    }

    protected abstract <T extends CalculusFieldElement<T>> T getLightingRatio(FieldVector3D<T> var1, FieldVector3D<T> var2);
}

