/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.trigger;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.events.Action;
import org.orekit.forces.maneuvers.trigger.AbstractManeuverTriggers;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public abstract class StartStopEventsTrigger<A extends AbstractDetector<A>, O extends AbstractDetector<O>>
extends AbstractManeuverTriggers {
    private final A startDetector;
    private final O stopDetector;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, FieldEventDetector<? extends CalculusFieldElement<?>>> cachedStart;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, FieldEventDetector<? extends CalculusFieldElement<?>>> cachedStop;

    protected StartStopEventsTrigger(A prototypeStartDetector, O prototypeStopDetector) {
        this.startDetector = ((AbstractDetector)prototypeStartDetector).withHandler(new StartHandler());
        this.stopDetector = ((AbstractDetector)prototypeStopDetector).withHandler(new StopHandler());
        this.cachedStart = new HashMap();
        this.cachedStop = new HashMap();
    }

    public A getStartDetector() {
        return this.startDetector;
    }

    public O getStopDetector() {
        return this.stopDetector;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        ((AbstractDetector)this.startDetector).init(initialState, target);
        ((AbstractDetector)this.stopDetector).init(initialState, target);
        super.init(initialState, target);
    }

    @Override
    protected boolean isFiringOnInitialState(SpacecraftState initialState, boolean isForward) {
        double startG = this.startDetector.g(initialState);
        if (startG == 0.0) {
            boolean increasing;
            boolean bl = increasing = this.startDetector.g(initialState.shiftedBy(2.0 * ((AbstractDetector)this.startDetector).getThreshold())) > 0.0;
            if (increasing) {
                this.notifyResetters(initialState, true);
                return isForward;
            }
            return false;
        }
        if (startG < 0.0) {
            return false;
        }
        double stopG = this.stopDetector.g(initialState);
        if (stopG == 0.0) {
            boolean increasing;
            boolean bl = increasing = this.stopDetector.g(initialState.shiftedBy(2.0 * ((AbstractDetector)this.stopDetector).getThreshold())) > 0.0;
            if (increasing) {
                this.notifyResetters(initialState, false);
                return !isForward;
            }
            return false;
        }
        return !(stopG > 0.0);
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        return Stream.of(this.startDetector, this.stopDetector);
    }

    public <S extends CalculusFieldElement<S>> Stream<FieldEventDetector<S>> getFieldEventDetectors(Field<S> field) {
        FieldEventDetector<Object> fStop;
        FieldEventDetector<Object> fStart = this.cachedStart.get(field);
        if (fStart == null) {
            fStart = this.convertAndSetUpStartHandler(field);
            this.cachedStart.put(field, fStart);
        }
        if ((fStop = this.cachedStop.get(field)) == null) {
            fStop = this.convertAndSetUpStopHandler(field);
            this.cachedStop.put(field, fStop);
        }
        return Stream.of(fStart, fStop);
    }

    private <D extends FieldAbstractDetector<D, S>, S extends CalculusFieldElement<S>> D convertAndSetUpStartHandler(Field<S> field) {
        FieldAbstractDetector<D, S> converted = this.convertStartDetector(field, this.startDetector);
        FieldAdaptableInterval maxCheck = s -> ((AbstractDetector)this.startDetector).getMaxCheckInterval().currentInterval(s.toSpacecraftState());
        return ((FieldAbstractDetector)((FieldAbstractDetector)converted.withMaxCheck(maxCheck)).withThreshold((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(((AbstractDetector)this.startDetector).getThreshold())))).withHandler(new FieldStartHandler());
    }

    private <D extends FieldAbstractDetector<D, S>, S extends CalculusFieldElement<S>> D convertAndSetUpStopHandler(Field<S> field) {
        FieldAbstractDetector<D, S> converted = this.convertStopDetector(field, this.stopDetector);
        FieldAdaptableInterval maxCheck = s -> ((AbstractDetector)this.stopDetector).getMaxCheckInterval().currentInterval(s.toSpacecraftState());
        return ((FieldAbstractDetector)((FieldAbstractDetector)converted.withMaxCheck(maxCheck)).withThreshold((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(((AbstractDetector)this.stopDetector).getThreshold())))).withHandler(new FieldStopHandler());
    }

    protected abstract <D extends FieldAbstractDetector<D, S>, S extends CalculusFieldElement<S>> FieldAbstractDetector<D, S> convertStartDetector(Field<S> var1, A var2);

    protected abstract <D extends FieldAbstractDetector<D, S>, S extends CalculusFieldElement<S>> FieldAbstractDetector<D, S> convertStopDetector(Field<S> var1, O var2);

    private class FieldStopHandler<S extends CalculusFieldElement<S>>
    implements FieldEventHandler<S> {
        private boolean forward;

        private FieldStopHandler() {
        }

        @Override
        public void init(FieldSpacecraftState<S> initialState, FieldAbsoluteDate<S> target, FieldEventDetector<S> detector) {
            this.forward = target.isAfterOrEqualTo(initialState);
            StartStopEventsTrigger.this.initializeResetters(initialState, target);
        }

        @Override
        public Action eventOccurred(FieldSpacecraftState<S> s, FieldEventDetector<S> detector, boolean increasing) {
            if (increasing) {
                if (this.forward) {
                    StartStopEventsTrigger.this.getFirings().addValidAfter(false, s.getDate().toAbsoluteDate(), false);
                } else {
                    StartStopEventsTrigger.this.getFirings().addValidBefore(true, s.getDate().toAbsoluteDate(), false);
                }
                StartStopEventsTrigger.this.notifyResetters(s, false);
                return Action.RESET_STATE;
            }
            return Action.CONTINUE;
        }

        @Override
        public FieldSpacecraftState<S> resetState(FieldEventDetector<S> detector, FieldSpacecraftState<S> oldState) {
            return StartStopEventsTrigger.this.applyResetters(oldState);
        }
    }

    private class FieldStartHandler<S extends CalculusFieldElement<S>>
    implements FieldEventHandler<S> {
        private boolean forward;

        private FieldStartHandler() {
        }

        @Override
        public void init(FieldSpacecraftState<S> initialState, FieldAbsoluteDate<S> target, FieldEventDetector<S> detector) {
            this.forward = target.isAfterOrEqualTo(initialState);
            StartStopEventsTrigger.this.initializeResetters(initialState, target);
        }

        @Override
        public Action eventOccurred(FieldSpacecraftState<S> s, FieldEventDetector<S> detector, boolean increasing) {
            if (increasing) {
                if (this.forward) {
                    StartStopEventsTrigger.this.getFirings().addValidAfter(true, s.getDate().toAbsoluteDate(), false);
                } else {
                    StartStopEventsTrigger.this.getFirings().addValidBefore(false, s.getDate().toAbsoluteDate(), false);
                }
                StartStopEventsTrigger.this.notifyResetters(s, true);
                return Action.RESET_STATE;
            }
            return Action.CONTINUE;
        }

        @Override
        public FieldSpacecraftState<S> resetState(FieldEventDetector<S> detector, FieldSpacecraftState<S> oldState) {
            return StartStopEventsTrigger.this.applyResetters(oldState);
        }
    }

    private class StopHandler
    implements EventHandler {
        private boolean forward;

        private StopHandler() {
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target, EventDetector detector) {
            this.forward = target.isAfterOrEqualTo(initialState);
            StartStopEventsTrigger.this.initializeResetters(initialState, target);
        }

        @Override
        public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
            if (increasing) {
                if (this.forward) {
                    StartStopEventsTrigger.this.getFirings().addValidAfter(false, s.getDate(), false);
                } else {
                    StartStopEventsTrigger.this.getFirings().addValidBefore(true, s.getDate(), false);
                }
                StartStopEventsTrigger.this.notifyResetters(s, false);
                return Action.RESET_STATE;
            }
            return Action.CONTINUE;
        }

        @Override
        public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
            return StartStopEventsTrigger.this.applyResetters(oldState);
        }
    }

    private class StartHandler
    implements EventHandler {
        private boolean forward;

        private StartHandler() {
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target, EventDetector detector) {
            this.forward = target.isAfterOrEqualTo(initialState);
            StartStopEventsTrigger.this.initializeResetters(initialState, target);
        }

        @Override
        public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
            if (increasing) {
                if (this.forward) {
                    StartStopEventsTrigger.this.getFirings().addValidAfter(true, s.getDate(), false);
                } else {
                    StartStopEventsTrigger.this.getFirings().addValidBefore(false, s.getDate(), false);
                }
                StartStopEventsTrigger.this.notifyResetters(s, true);
                return Action.RESET_STATE;
            }
            return Action.CONTINUE;
        }

        @Override
        public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
            return StartStopEventsTrigger.this.applyResetters(oldState);
        }
    }
}

