/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.trigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.forces.maneuvers.trigger.FieldManeuverTriggersResetter;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggersResetter;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public abstract class AbstractManeuverTriggers
implements ManeuverTriggers {
    private TimeSpanMap<Boolean> firings = new TimeSpanMap<Boolean>(Boolean.FALSE);
    private boolean forward;
    private final List<ManeuverTriggersResetter> resetters = new ArrayList<ManeuverTriggersResetter>();
    private final transient Map<Field<? extends CalculusFieldElement<?>>, List<FieldManeuverTriggersResetter<?>>> fieldResetters = new HashMap();

    protected AbstractManeuverTriggers() {
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.forward = target.isAfterOrEqualTo(initialState);
        this.firings = new TimeSpanMap<Boolean>(Boolean.FALSE);
        this.initializeResetters(initialState, target);
        if (this.isFiringOnInitialState(initialState, this.forward)) {
            if (this.forward) {
                this.firings.addValidAfter(Boolean.TRUE, initialState.getDate(), false);
            } else {
                this.firings.addValidBefore(Boolean.TRUE, initialState.getDate(), false);
            }
        }
    }

    @Override
    public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.forward = target.isAfterOrEqualTo(initialState);
        this.firings = new TimeSpanMap<Boolean>(Boolean.FALSE);
        List<FieldManeuverTriggersResetter<?>> list = this.fieldResetters.get(initialState.getDate().getField());
        if (list != null) {
            for (FieldManeuverTriggersResetter<?> r : list) {
                r.init(initialState, target);
            }
        }
        if (this.isFiringOnInitialState(initialState.toSpacecraftState(), this.forward)) {
            if (this.forward) {
                this.firings.addValidAfter(Boolean.TRUE, initialState.getDate().toAbsoluteDate(), false);
            } else {
                this.firings.addValidBefore(Boolean.TRUE, initialState.getDate().toAbsoluteDate(), false);
            }
        }
    }

    protected abstract boolean isFiringOnInitialState(SpacecraftState var1, boolean var2);

    @Override
    public boolean isFiring(AbsoluteDate date, double[] parameters) {
        return this.firings.get(date);
    }

    public <S extends CalculusFieldElement<S>> boolean isFiring(FieldAbsoluteDate<S> date, S[] parameters) {
        return this.firings.get(date.toAbsoluteDate());
    }

    public TimeSpanMap<Boolean> getFirings() {
        return this.firings;
    }

    @Override
    public void addResetter(ManeuverTriggersResetter resetter) {
        this.resetters.add(resetter);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void addResetter(Field<T> field, FieldManeuverTriggersResetter<T> resetter) {
        List<FieldManeuverTriggersResetter<?>> list = this.fieldResetters.get(field);
        if (list == null) {
            list = new ArrayList();
            this.fieldResetters.put(field, list);
        }
        list.add(resetter);
    }

    protected void initializeResetters(SpacecraftState initialState, AbsoluteDate target) {
        for (ManeuverTriggersResetter r : this.resetters) {
            r.init(initialState, target);
        }
    }

    protected void notifyResetters(SpacecraftState state, boolean start) {
        for (ManeuverTriggersResetter r : this.resetters) {
            r.maneuverTriggered(state, start);
        }
    }

    protected SpacecraftState applyResetters(SpacecraftState state) {
        SpacecraftState reset = state;
        for (ManeuverTriggersResetter r : this.resetters) {
            reset = r.resetState(reset);
        }
        return reset;
    }

    protected <T extends CalculusFieldElement<T>> void initializeResetters(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        List<FieldManeuverTriggersResetter<?>> list = this.fieldResetters.get(initialState.getDate().getField());
        if (list != null) {
            Iterator<FieldManeuverTriggersResetter<?>> iterator = list.iterator();
            while (iterator.hasNext()) {
                FieldManeuverTriggersResetter<?> r;
                FieldManeuverTriggersResetter<?> tr = r = iterator.next();
                tr.init(initialState, target);
            }
        }
    }

    protected <T extends CalculusFieldElement<T>> void notifyResetters(FieldSpacecraftState<T> state, boolean start) {
        List<FieldManeuverTriggersResetter<?>> list = this.fieldResetters.get(state.getDate().getField());
        if (list != null) {
            Iterator<FieldManeuverTriggersResetter<?>> iterator = list.iterator();
            while (iterator.hasNext()) {
                FieldManeuverTriggersResetter<?> r;
                FieldManeuverTriggersResetter<?> tr = r = iterator.next();
                tr.maneuverTriggered(state, start);
            }
        }
    }

    protected <T extends CalculusFieldElement<T>> FieldSpacecraftState<T> applyResetters(FieldSpacecraftState<T> state) {
        FieldSpacecraftState<Object> reset = state;
        List<FieldManeuverTriggersResetter<?>> list = this.fieldResetters.get(state.getDate().getField());
        if (list != null) {
            Iterator<FieldManeuverTriggersResetter<?>> iterator = list.iterator();
            while (iterator.hasNext()) {
                FieldManeuverTriggersResetter<?> r;
                FieldManeuverTriggersResetter<?> tr = r = iterator.next();
                reset = tr.resetState(reset);
            }
        }
        return reset;
    }
}

