/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.maneuvers.propulsion.PropulsionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public interface ThrustPropulsionModel
extends PropulsionModel {
    default public double getIsp(SpacecraftState s) {
        double flowRate = this.getFlowRate(s);
        return -this.getControl3DVectorCostType().evaluate(this.getThrustVector(s)) / (9.80665 * flowRate);
    }

    default public Vector3D getDirection(SpacecraftState s) {
        Vector3D thrustVector = this.getThrustVector(s);
        double norm = thrustVector.getNorm();
        if (norm <= Precision.EPSILON) {
            return Vector3D.ZERO;
        }
        return thrustVector.scalarMultiply(1.0 / norm);
    }

    public Vector3D getThrustVector(SpacecraftState var1);

    public double getFlowRate(SpacecraftState var1);

    public Vector3D getThrustVector(SpacecraftState var1, double[] var2);

    public double getFlowRate(SpacecraftState var1, double[] var2);

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getThrustVector(FieldSpacecraftState<T> var1, T[] var2);

    public <T extends CalculusFieldElement<T>> T getFlowRate(FieldSpacecraftState<T> var1, T[] var2);

    @Override
    default public Vector3D getAcceleration(SpacecraftState s, Attitude maneuverAttitude, double[] parameters) {
        Vector3D thrustVector = this.getThrustVector(s, parameters);
        double thrustNorm = thrustVector.getNorm();
        if (thrustNorm == 0.0) {
            return Vector3D.ZERO;
        }
        Vector3D direction = (Vector3D)thrustVector.normalize();
        return new Vector3D(thrustNorm / s.getMass(), maneuverAttitude.getRotation().applyInverseTo(direction));
    }

    @Override
    default public <T extends CalculusFieldElement<T>> FieldVector3D<T> getAcceleration(FieldSpacecraftState<T> s, FieldAttitude<T> maneuverAttitude, T[] parameters) {
        FieldVector3D thrustVector = this.getThrustVector(s, (CalculusFieldElement[])parameters);
        CalculusFieldElement thrustNorm = thrustVector.getNorm();
        if (thrustNorm.getReal() == 0.0) {
            return maneuverAttitude.getRotation().applyInverseTo(thrustVector.scalarMultiply((CalculusFieldElement)s.getMass().reciprocal()));
        }
        FieldVector3D direction = thrustVector.normalize();
        return new FieldVector3D((CalculusFieldElement)thrustNorm.divide(s.getMass()), maneuverAttitude.getRotation().applyInverseTo(direction));
    }

    @Override
    default public double getMassDerivatives(SpacecraftState s, double[] parameters) {
        return this.getFlowRate(s, parameters);
    }

    @Override
    default public <T extends CalculusFieldElement<T>> T getMassDerivatives(FieldSpacecraftState<T> s, T[] parameters) {
        return (T)this.getFlowRate(s, (CalculusFieldElement[])parameters);
    }
}

