/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.EventDetectorsProvider;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriversProvider;

public interface PropulsionModel
extends ParameterDriversProvider,
EventDetectorsProvider {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.init(initialState.toSpacecraftState(), target.toAbsoluteDate());
    }

    @Override
    default public Stream<EventDetector> getEventDetectors() {
        return this.getEventDetectors(this.getParametersDrivers());
    }

    @Override
    default public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return this.getFieldEventDetectors(field, this.getParametersDrivers());
    }

    public Vector3D getAcceleration(SpacecraftState var1, Attitude var2, double[] var3);

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getAcceleration(FieldSpacecraftState<T> var1, FieldAttitude<T> var2, T[] var3);

    public double getMassDerivatives(SpacecraftState var1, double[] var2);

    public <T extends CalculusFieldElement<T>> T getMassDerivatives(FieldSpacecraftState<T> var1, T[] var2);

    default public String getName() {
        return "";
    }

    public Control3DVectorCostType getControl3DVectorCostType();
}

