/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.forces.maneuvers.propulsion.PolynomialThrustSegment;
import org.orekit.forces.maneuvers.propulsion.ThrustPropulsionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldDateDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class ProfileThrustPropulsionModel
implements ThrustPropulsionModel {
    private static final double DATATION_ACCURACY = 1.0E-10;
    private final TimeSpanMap<PolynomialThrustSegment> profile;
    private final double isp;
    private final String name;
    private final Control3DVectorCostType control3DVectorCostType;

    public ProfileThrustPropulsionModel(TimeSpanMap<PolynomialThrustSegment> profile, double isp, Control3DVectorCostType control3DVectorCostType, String name) {
        this.name = name;
        this.isp = isp;
        this.profile = profile;
        this.control3DVectorCostType = control3DVectorCostType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Control3DVectorCostType getControl3DVectorCostType() {
        return this.control3DVectorCostType;
    }

    @Override
    public Vector3D getThrustVector(SpacecraftState s) {
        PolynomialThrustSegment active = this.profile.get(s.getDate());
        return active == null ? Vector3D.ZERO : active.getThrustVector(s.getDate());
    }

    @Override
    public double getFlowRate(SpacecraftState s) {
        return -this.control3DVectorCostType.evaluate(this.getThrustVector(s)) / (9.80665 * this.isp);
    }

    @Override
    public Vector3D getThrustVector(SpacecraftState s, double[] parameters) {
        return this.getThrustVector(s);
    }

    @Override
    public double getFlowRate(SpacecraftState s, double[] parameters) {
        return this.getFlowRate(s);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getThrustVector(FieldSpacecraftState<T> s, T[] parameters) {
        PolynomialThrustSegment active = this.profile.get(s.getDate().toAbsoluteDate());
        return active == null ? FieldVector3D.getZero(s.getDate().getField()) : active.getThrustVector(s.getDate());
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getFlowRate(FieldSpacecraftState<T> s, T[] parameters) {
        return (T)((CalculusFieldElement)this.control3DVectorCostType.evaluate(this.getThrustVector(s, (CalculusFieldElement[])parameters)).divide(-9.80665 * this.isp));
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        double shortest = this.shortestSegmentDuration();
        DateDetector detector = (DateDetector)((DateDetector)((DateDetector)new DateDetector(new TimeStamped[0]).withMaxCheck(0.5 * shortest)).withMinGap(0.5 * shortest).withThreshold(1.0E-10)).withHandler(new ResetDerivativesOnEvent());
        for (TimeSpanMap.Transition<PolynomialThrustSegment> transition = this.profile.getFirstTransition(); transition != null; transition = transition.next()) {
            detector.addEventDate(transition.getDate());
        }
        return Stream.of(detector);
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        double shortest = this.shortestSegmentDuration();
        FieldDateDetector detector = (FieldDateDetector)((FieldDateDetector)((FieldDateDetector)new FieldDateDetector<T>(field, (FieldTimeStamped[])Array.newInstance(FieldTimeStamped.class, 0)).withMaxCheck(0.5 * shortest)).withMinGap(0.5 * shortest).withThreshold((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-10))).withHandler(new FieldResetDerivativesOnEvent());
        for (TimeSpanMap.Transition<PolynomialThrustSegment> transition = this.profile.getFirstTransition(); transition != null; transition = transition.next()) {
            detector.addEventDate(new FieldAbsoluteDate<T>(field, transition.getDate()));
        }
        return Stream.of(detector);
    }

    private double shortestSegmentDuration() {
        double shortest = Double.POSITIVE_INFINITY;
        for (TimeSpanMap.Span<PolynomialThrustSegment> span = this.profile.getFirstSpan(); span != null; span = span.next()) {
            shortest = FastMath.min((double)shortest, (double)span.getEnd().durationFrom(span.getStart()));
        }
        return shortest;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

