/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class PolynomialThrustSegment {
    private final AbsoluteDate referenceDate;
    private final PolynomialFunction xThrust;
    private final PolynomialFunction yThrust;
    private final PolynomialFunction zThrust;

    public PolynomialThrustSegment(AbsoluteDate referenceDate, PolynomialFunction xThrust, PolynomialFunction yThrust, PolynomialFunction zThrust) {
        this.referenceDate = referenceDate;
        this.xThrust = xThrust;
        this.yThrust = yThrust;
        this.zThrust = zThrust;
    }

    public Vector3D getThrustVector(AbsoluteDate date) {
        double dt = date.durationFrom(this.referenceDate);
        return new Vector3D(this.xThrust.value(dt), this.yThrust.value(dt), this.zThrust.value(dt));
    }

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getThrustVector(FieldAbsoluteDate<T> date) {
        T dt = date.durationFrom(this.referenceDate);
        return new FieldVector3D(this.xThrust.value(dt), this.yThrust.value(dt), this.zThrust.value(dt));
    }
}

