/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.forces.maneuvers.propulsion.AbstractConstantThrustPropulsionModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class BasicConstantThrustPropulsionModel
extends AbstractConstantThrustPropulsionModel {
    public static final String THRUST = "thrust";
    public static final String FLOW_RATE = "flow rate";
    public static final double THRUST_SCALE = FastMath.scalb((double)1.0, (int)-5);
    public static final double FLOW_RATE_SCALE = FastMath.scalb((double)1.0, (int)-12);
    private final ParameterDriver thrustDriver;
    private final ParameterDriver flowRateDriver;
    private final Vector3D direction;

    public BasicConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, Control3DVectorCostType control3DVectorCostType, String name) {
        super(thrust, isp, direction, control3DVectorCostType, name);
        this.direction = (Vector3D)direction.normalize();
        double initialFlowRate = super.getInitialFlowRate();
        this.thrustDriver = new ParameterDriver(name + THRUST, thrust, THRUST_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.flowRateDriver = new ParameterDriver(name + FLOW_RATE, initialFlowRate, FLOW_RATE_SCALE, Double.NEGATIVE_INFINITY, 0.0);
    }

    public BasicConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, String name) {
        this(thrust, isp, direction, DEFAULT_CONTROL_3D_VECTOR_COST_TYPE, name);
    }

    @Override
    public Vector3D getThrustVector() {
        return this.direction.scalarMultiply(this.thrustDriver.getValue());
    }

    @Override
    public Vector3D getThrustVector(AbsoluteDate date) {
        return this.direction.scalarMultiply(this.thrustDriver.getValue(date));
    }

    @Override
    public double getFlowRate() {
        return this.flowRateDriver.getValue();
    }

    @Override
    public double getFlowRate(AbsoluteDate date) {
        return this.flowRateDriver.getValue(date);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.unmodifiableList(Arrays.asList(this.thrustDriver, this.flowRateDriver));
    }

    @Override
    public Vector3D getThrustVector(double[] parameters) {
        return this.direction.scalarMultiply(parameters[0]);
    }

    @Override
    public double getFlowRate(double[] parameters) {
        return parameters[1];
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getThrustVector(T[] parameters) {
        return new FieldVector3D(parameters[0], this.direction);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getFlowRate(T[] parameters) {
        return parameters[1];
    }
}

