/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.forces.maneuvers.propulsion.ThrustPropulsionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractConstantThrustPropulsionModel
implements ThrustPropulsionModel {
    static final Control3DVectorCostType DEFAULT_CONTROL_3D_VECTOR_COST_TYPE = Control3DVectorCostType.TWO_NORM;
    private final Vector3D initialThrustVector;
    private final double initialFlowRate;
    private final Control3DVectorCostType control3DVectorCostType;
    private final String name;

    public AbstractConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, Control3DVectorCostType control3DVectorCostType, String name) {
        this.name = name;
        this.initialThrustVector = ((Vector3D)direction.normalize()).scalarMultiply(thrust);
        this.control3DVectorCostType = control3DVectorCostType;
        this.initialFlowRate = -control3DVectorCostType.evaluate(this.initialThrustVector) / (9.80665 * isp);
    }

    public AbstractConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, String name) {
        this(thrust, isp, direction, DEFAULT_CONTROL_3D_VECTOR_COST_TYPE, name);
    }

    protected Vector3D getInitialThrustVector() {
        return this.initialThrustVector;
    }

    protected double getInitialFlowRate() {
        return this.initialFlowRate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Control3DVectorCostType getControl3DVectorCostType() {
        return this.control3DVectorCostType;
    }

    public double getIsp() {
        double flowRate = this.getFlowRate();
        return -this.control3DVectorCostType.evaluate(this.getThrustVector()) / (9.80665 * flowRate);
    }

    public double getIsp(AbsoluteDate date) {
        double flowRate = this.getFlowRate(date);
        return -this.control3DVectorCostType.evaluate(this.getThrustVector(date)) / (9.80665 * flowRate);
    }

    public Vector3D getDirection(AbsoluteDate date) {
        return (Vector3D)this.getThrustVector(date).normalize();
    }

    public Vector3D getDirection() {
        return (Vector3D)this.getThrustVector().normalize();
    }

    public double getThrustMagnitude() {
        return this.getThrustVector().getNorm();
    }

    public double getThrustMagnitude(AbsoluteDate date) {
        return this.getThrustVector(date).getNorm();
    }

    @Override
    public Vector3D getThrustVector(SpacecraftState s) {
        return this.getThrustVector(s.getDate());
    }

    @Override
    public double getFlowRate(SpacecraftState s) {
        return this.getFlowRate(s.getDate());
    }

    @Override
    public Vector3D getThrustVector(SpacecraftState s, double[] parameters) {
        return this.getThrustVector(parameters);
    }

    @Override
    public double getFlowRate(SpacecraftState s, double[] parameters) {
        return this.getFlowRate(parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getThrustVector(FieldSpacecraftState<T> s, T[] parameters) {
        return this.getThrustVector((CalculusFieldElement[])parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getFlowRate(FieldSpacecraftState<T> s, T[] parameters) {
        return (T)this.getFlowRate((CalculusFieldElement[])parameters);
    }

    public abstract Vector3D getThrustVector();

    public abstract Vector3D getThrustVector(AbsoluteDate var1);

    public abstract double getFlowRate();

    public abstract double getFlowRate(AbsoluteDate var1);

    public abstract Vector3D getThrustVector(double[] var1);

    public abstract double getFlowRate(double[] var1);

    public abstract <T extends CalculusFieldElement<T>> FieldVector3D<T> getThrustVector(T[] var1);

    public abstract <T extends CalculusFieldElement<T>> T getFlowRate(T[] var1);
}

