/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.jacobians;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.forces.maneuvers.Maneuver;
import org.orekit.forces.maneuvers.jacobians.MassDepletionDelay;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggersResetter;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class TriggerDate
implements AdditionalStateProvider,
ManeuverTriggersResetter {
    private static final int STATE_DIMENSION = 6;
    private static final double DECOMPOSITION_THRESHOLD = 1.0E-10;
    private final String stmName;
    private final String triggerName;
    private final MassDepletionDelay massDepletionDelay;
    private final boolean manageStart;
    private final Maneuver maneuver;
    private final double threshold;
    private TimeSpanMap<double[]> contribution;
    private AbsoluteDate trigger;
    private boolean forward;

    public TriggerDate(String stmName, String triggerName, boolean manageStart, Maneuver maneuver, double threshold) {
        this.stmName = stmName;
        this.triggerName = triggerName;
        this.massDepletionDelay = new MassDepletionDelay(triggerName, manageStart, maneuver);
        this.manageStart = manageStart;
        this.maneuver = maneuver;
        this.threshold = threshold;
        this.contribution = null;
        this.trigger = null;
        this.forward = true;
    }

    @Override
    public String getName() {
        return this.triggerName;
    }

    @Override
    public boolean yields(SpacecraftState state) {
        return !state.hasAdditionalState(this.stmName) || !state.hasAdditionalState(this.massDepletionDelay.getName());
    }

    public MassDepletionDelay getMassDepletionDelay() {
        return this.massDepletionDelay;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        boolean newForward = target.isAfterOrEqualTo(initialState);
        if (this.contribution == null || this.forward ^ newForward) {
            this.contribution = new TimeSpanMap<Object>(null);
            this.trigger = null;
        }
        this.forward = newForward;
    }

    @Override
    public double[] getAdditionalState(SpacecraftState state) {
        double[] c;
        double[] dArray = c = this.contribution == null ? null : this.contribution.get(state.getDate());
        if (c == null) {
            return new double[6];
        }
        double[] effect = this.getStm(state).operate(c);
        double[] secondary = state.getAdditionalState(this.massDepletionDelay.getName());
        for (int i = 0; i < effect.length; ++i) {
            int n = i;
            effect[n] = effect[n] + secondary[i];
        }
        return effect;
    }

    @Override
    public void maneuverTriggered(SpacecraftState state, boolean start) {
        this.trigger = start == this.manageStart ? state.getDate() : null;
    }

    @Override
    public SpacecraftState resetState(SpacecraftState state) {
        if (this.trigger == null) {
            return state;
        }
        SpacecraftState stateWhenFiring = state.shiftedBy((double)(this.manageStart ? 2 : -2) * this.threshold);
        Vector3D acceleration = this.maneuver.acceleration(stateWhenFiring, this.maneuver.getParameters(state.getDate()));
        double sign = this.forward == this.manageStart ? -1.0 : 1.0;
        RealVector rhs = MatrixUtils.createRealVector((int)6);
        rhs.setEntry(3, sign * acceleration.getX());
        rhs.setEntry(4, sign * acceleration.getY());
        rhs.setEntry(5, sign * acceleration.getZ());
        RealMatrix dY1dY0 = this.getStm(state);
        double[] c = new QRDecomposition(dY1dY0, 1.0E-10).getSolver().solve(rhs).toArray();
        if (this.forward) {
            this.contribution.addValidAfter(c, state.getDate(), false);
        } else {
            this.contribution.addValidBefore(c, state.getDate(), false);
        }
        return state;
    }

    private RealMatrix getStm(SpacecraftState state) {
        double[] p = state.getAdditionalState(this.stmName);
        RealMatrix dYdY0 = MatrixUtils.createRealMatrix((int)6, (int)6);
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                dYdY0.setEntry(i, j, p[index++]);
            }
        }
        return dYdY0;
    }
}

