/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.ForceModel;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.forces.maneuvers.propulsion.PropulsionModel;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class Maneuver
implements ForceModel {
    private final AttitudeProvider attitudeOverride;
    private final PropulsionModel propulsionModel;
    private final ManeuverTriggers maneuverTriggers;

    public Maneuver(AttitudeProvider attitudeOverride, ManeuverTriggers maneuverTriggers, PropulsionModel propulsionModel) {
        this.maneuverTriggers = maneuverTriggers;
        this.attitudeOverride = attitudeOverride;
        this.propulsionModel = propulsionModel;
    }

    public String getName() {
        String name = this.propulsionModel.getName();
        if (name.length() < 1) {
            name = this.maneuverTriggers.getName();
        }
        return name;
    }

    public AttitudeProvider getAttitudeOverride() {
        return this.attitudeOverride;
    }

    public Control3DVectorCostType getControl3DVectorCostType() {
        return this.propulsionModel.getControl3DVectorCostType();
    }

    public PropulsionModel getPropulsionModel() {
        return this.propulsionModel;
    }

    public ManeuverTriggers getManeuverTriggers() {
        return this.maneuverTriggers;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.propulsionModel.init(initialState, target);
        this.maneuverTriggers.init(initialState, target);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.propulsionModel.init(initialState, target);
        this.maneuverTriggers.init(initialState, target);
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        double[] parameters = this.getParameters(s.getDate());
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters(parameters))) {
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(this.propulsionModel.getMassDerivatives(s, this.getPropulsionModelParameters(parameters)));
        }
    }

    @Override
    public <T extends CalculusFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        CalculusFieldElement[] parameters = this.getParameters(s.getDate().getField(), s.getDate());
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters(parameters))) {
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(this.propulsionModel.getMassDerivatives(s, this.getPropulsionModelParameters(parameters)));
        }
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters(parameters))) {
            Attitude maneuverAttitude;
            if (this.attitudeOverride == null) {
                maneuverAttitude = s.getAttitude();
            } else {
                Rotation rotation = this.attitudeOverride.getAttitudeRotation(s.getOrbit(), s.getDate(), s.getFrame());
                maneuverAttitude = new Attitude(s.getDate(), s.getFrame(), rotation, Vector3D.ZERO, Vector3D.ZERO);
            }
            return this.propulsionModel.getAcceleration(s, maneuverAttitude, this.getPropulsionModelParameters(parameters));
        }
        return Vector3D.ZERO;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters((CalculusFieldElement[])parameters))) {
            FieldAttitude<T> maneuverAttitude;
            if (this.attitudeOverride == null) {
                maneuverAttitude = s.getAttitude();
            } else {
                FieldRotation<T> rotation = this.attitudeOverride.getAttitudeRotation(s.getOrbit(), s.getDate(), s.getFrame());
                FieldVector3D zeroVector3D = FieldVector3D.getZero(s.getDate().getField());
                maneuverAttitude = new FieldAttitude<T>(s.getDate(), s.getFrame(), rotation, zeroVector3D, zeroVector3D);
            }
            return this.propulsionModel.getAcceleration(s, maneuverAttitude, this.getPropulsionModelParameters((CalculusFieldElement[])parameters));
        }
        return FieldVector3D.getZero((Field)s.getMu().getField());
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        return Stream.concat(this.maneuverTriggers.getEventDetectors(), this.propulsionModel.getEventDetectors());
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return Stream.concat(this.maneuverTriggers.getFieldEventDetectors(field), this.propulsionModel.getFieldEventDetectors(field));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        List<ParameterDriver> propulsionModelDrivers = this.propulsionModel.getParametersDrivers();
        List<ParameterDriver> maneuverTriggersDrivers = this.maneuverTriggers.getParametersDrivers();
        int propulsionModelDriversLength = propulsionModelDrivers.size();
        int maneuverTriggersDriversLength = maneuverTriggersDrivers.size();
        ArrayList<ParameterDriver> drivers = new ArrayList<ParameterDriver>(propulsionModelDriversLength + maneuverTriggersDriversLength);
        drivers.addAll(0, propulsionModelDrivers);
        drivers.addAll(propulsionModelDriversLength, maneuverTriggersDrivers);
        return drivers;
    }

    public double[] getPropulsionModelParameters(double[] parameters) {
        return Arrays.copyOfRange(parameters, 0, this.propulsionModel.getParametersDrivers().size());
    }

    public <T extends CalculusFieldElement<T>> T[] getPropulsionModelParameters(T[] parameters) {
        return (CalculusFieldElement[])Arrays.copyOfRange(parameters, 0, this.propulsionModel.getParametersDrivers().size());
    }

    public double[] getManeuverTriggersParameters(double[] parameters) {
        int nbPropulsionModelDrivers = this.propulsionModel.getParametersDrivers().size();
        return Arrays.copyOfRange(parameters, nbPropulsionModelDrivers, nbPropulsionModelDrivers + this.maneuverTriggers.getParametersDrivers().size());
    }

    public <T extends CalculusFieldElement<T>> T[] getManeuverTriggersParameters(T[] parameters) {
        int nbPropulsionModelDrivers = this.propulsionModel.getParametersDrivers().size();
        return (CalculusFieldElement[])Arrays.copyOfRange(parameters, nbPropulsionModelDrivers, nbPropulsionModelDrivers + this.maneuverTriggers.getParametersDrivers().size());
    }
}

