/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ImpulseManeuver
extends AbstractDetector<ImpulseManeuver> {
    private final AttitudeProvider attitudeOverride;
    private final EventDetector trigger;
    private final Vector3D deltaVSat;
    private final double isp;
    private final double vExhaust;
    private boolean forward;
    private final Control3DVectorCostType control3DVectorCostType;

    public ImpulseManeuver(EventDetector trigger, Vector3D deltaVSat, double isp) {
        this(trigger, null, deltaVSat, isp);
    }

    public ImpulseManeuver(EventDetector trigger, AttitudeProvider attitudeOverride, Vector3D deltaVSat, double isp) {
        this(trigger.getMaxCheckInterval(), trigger.getThreshold(), trigger.getMaxIterationCount(), new Handler(), trigger, attitudeOverride, deltaVSat, isp, Control3DVectorCostType.TWO_NORM);
    }

    public ImpulseManeuver(EventDetector trigger, AttitudeProvider attitudeOverride, Vector3D deltaVSat, double isp, Control3DVectorCostType control3DVectorCostType) {
        this(trigger.getMaxCheckInterval(), trigger.getThreshold(), trigger.getMaxIterationCount(), new Handler(), trigger, attitudeOverride, deltaVSat, isp, control3DVectorCostType);
    }

    protected ImpulseManeuver(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, EventDetector trigger, AttitudeProvider attitudeOverride, Vector3D deltaVSat, double isp, Control3DVectorCostType control3DVectorCostType) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.attitudeOverride = attitudeOverride;
        this.trigger = trigger;
        this.deltaVSat = deltaVSat;
        this.isp = isp;
        this.vExhaust = 9.80665 * isp;
        this.control3DVectorCostType = control3DVectorCostType;
    }

    @Override
    protected ImpulseManeuver create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new ImpulseManeuver(newMaxCheck, newThreshold, newMaxIter, newHandler, this.trigger, this.attitudeOverride, this.deltaVSat, this.isp, this.control3DVectorCostType);
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.forward = t.durationFrom(s0.getDate()) >= 0.0;
        this.trigger.init(s0, t);
    }

    @Override
    public double g(SpacecraftState s) {
        return this.trigger.g(s);
    }

    public AttitudeProvider getAttitudeOverride() {
        return this.attitudeOverride;
    }

    public EventDetector getTrigger() {
        return this.trigger;
    }

    public Vector3D getDeltaVSat() {
        return this.deltaVSat;
    }

    public double getIsp() {
        return this.isp;
    }

    public Control3DVectorCostType getControl3DVectorCostType() {
        return this.control3DVectorCostType;
    }

    private static class Handler
    implements EventHandler {
        private Handler() {
        }

        @Override
        public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
            ImpulseManeuver im = (ImpulseManeuver)detector;
            Action underlyingAction = im.trigger.getHandler().eventOccurred(s, im.trigger, increasing);
            return underlyingAction == Action.STOP ? Action.RESET_STATE : Action.CONTINUE;
        }

        @Override
        public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
            ImpulseManeuver im = (ImpulseManeuver)detector;
            AbsoluteDate date = oldState.getDate();
            AttitudeProvider override = im.getAttitudeOverride();
            Rotation rotation = override == null ? oldState.getAttitude().getRotation() : override.getAttitudeRotation(oldState.getOrbit(), date, oldState.getFrame());
            Vector3D deltaV = rotation.applyInverseTo(im.deltaVSat);
            double sign = im.forward ? 1.0 : -1.0;
            TimeStampedPVCoordinates oldPV = oldState.getPVCoordinates();
            PVCoordinates newPV = new PVCoordinates(oldPV.getPosition(), new Vector3D(1.0, oldPV.getVelocity(), sign, deltaV));
            CartesianOrbit newOrbit = new CartesianOrbit(newPV, oldState.getFrame(), date, oldState.getMu());
            double normDeltaV = im.control3DVectorCostType.evaluate(im.deltaVSat);
            double newMass = oldState.getMass() * FastMath.exp((double)(-sign * normDeltaV / im.vExhaust));
            SpacecraftState newState = new SpacecraftState(oldState.getOrbit().getType().normalize(newOrbit, oldState.getOrbit()), oldState.getAttitude(), newMass);
            for (DoubleArrayDictionary.Entry entry : oldState.getAdditionalStatesValues().getData()) {
                newState = newState.addAdditionalState(entry.getKey(), entry.getValue());
            }
            for (DoubleArrayDictionary.Entry entry : oldState.getAdditionalStatesDerivatives().getData()) {
                newState = newState.addAdditionalStateDerivative(entry.getKey(), entry.getValue());
            }
            return newState;
        }
    }
}

