/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldArrayDictionary;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldImpulseManeuver<D extends FieldEventDetector<T>, T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldImpulseManeuver<D, T>, T> {
    private final AttitudeProvider attitudeOverride;
    private final D trigger;
    private final FieldVector3D<T> deltaVSat;
    private final T isp;
    private final T vExhaust;
    private boolean forward;
    private final Control3DVectorCostType control3DVectorCostType;

    public FieldImpulseManeuver(D trigger, FieldVector3D<T> deltaVSat, T isp) {
        this(trigger, null, deltaVSat, isp);
    }

    public FieldImpulseManeuver(D trigger, AttitudeProvider attitudeOverride, FieldVector3D<T> deltaVSat, T isp) {
        this(trigger.getDetectionSettings(), new Handler(), trigger, attitudeOverride, deltaVSat, isp, Control3DVectorCostType.TWO_NORM);
    }

    public FieldImpulseManeuver(D trigger, AttitudeProvider attitudeOverride, FieldVector3D<T> deltaVSat, T isp, Control3DVectorCostType control3DVectorCostType) {
        this(trigger.getDetectionSettings(), new Handler(), trigger, attitudeOverride, deltaVSat, isp, control3DVectorCostType);
    }

    private FieldImpulseManeuver(FieldEventDetectionSettings<T> detectionSettings, FieldEventHandler<T> eventHandler, D trigger, AttitudeProvider attitudeOverride, FieldVector3D<T> deltaVSat, T isp, Control3DVectorCostType control3DVectorCostType) {
        super(detectionSettings, eventHandler);
        this.trigger = trigger;
        this.deltaVSat = deltaVSat;
        this.isp = isp;
        this.attitudeOverride = attitudeOverride;
        this.control3DVectorCostType = control3DVectorCostType;
        this.vExhaust = (CalculusFieldElement)this.isp.multiply(9.80665);
    }

    @Override
    protected FieldImpulseManeuver<D, T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> fieldEventHandler) {
        return new FieldImpulseManeuver<D, T>(new FieldEventDetectionSettings<T>(newMaxCheck, newThreshold, newMaxIter), fieldEventHandler, this.trigger, this.attitudeOverride, this.deltaVSat, this.isp, this.control3DVectorCostType);
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.forward = t.durationFrom(s0.getDate()).getReal() >= 0.0;
        this.trigger.init(s0, t);
    }

    @Override
    public T g(FieldSpacecraftState<T> fieldSpacecraftState) {
        return this.trigger.g(fieldSpacecraftState);
    }

    public AttitudeProvider getAttitudeOverride() {
        return this.attitudeOverride;
    }

    public FieldEventDetector<T> getTrigger() {
        return this.trigger;
    }

    public FieldVector3D<T> getDeltaVSat() {
        return this.deltaVSat;
    }

    public T getIsp() {
        return this.isp;
    }

    public Control3DVectorCostType getControl3DVectorCostType() {
        return this.control3DVectorCostType;
    }

    private static class Handler<T extends CalculusFieldElement<T>>
    implements FieldEventHandler<T> {
        private Handler() {
        }

        @Override
        public Action eventOccurred(FieldSpacecraftState<T> s, FieldEventDetector<T> detector, boolean increasing) {
            FieldImpulseManeuver im = (FieldImpulseManeuver)detector;
            Action underlyingAction = im.trigger.getHandler().eventOccurred(s, im.trigger, increasing);
            return underlyingAction == Action.STOP ? Action.RESET_STATE : Action.CONTINUE;
        }

        @Override
        public FieldSpacecraftState<T> resetState(FieldEventDetector<T> detector, FieldSpacecraftState<T> oldState) {
            FieldImpulseManeuver im = (FieldImpulseManeuver)detector;
            FieldAbsoluteDate<T> date = oldState.getDate();
            FieldRotation<T> rotation = im.getAttitudeOverride() == null ? oldState.getAttitude().getRotation() : im.attitudeOverride.getAttitudeRotation(oldState.getOrbit(), date, oldState.getFrame());
            FieldVector3D deltaV = rotation.applyInverseTo(im.deltaVSat);
            CalculusFieldElement one = (CalculusFieldElement)oldState.getMu().getField().getOne();
            CalculusFieldElement sign = im.forward ? one : (CalculusFieldElement)one.negate();
            TimeStampedFieldPVCoordinates<T> oldPV = oldState.getPVCoordinates();
            FieldPVCoordinates newPV = new FieldPVCoordinates(oldPV.getPosition(), new FieldVector3D(one, oldPV.getVelocity(), sign, deltaV));
            FieldCartesianOrbit newOrbit = new FieldCartesianOrbit(newPV, oldState.getFrame(), date, oldState.getMu());
            Object normDeltaV = im.control3DVectorCostType.evaluate(im.deltaVSat);
            CalculusFieldElement newMass = (CalculusFieldElement)oldState.getMass().multiply((FieldElement)FastMath.exp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)normDeltaV.multiply((FieldElement)((CalculusFieldElement)sign.negate()))).divide((FieldElement)im.vExhaust))));
            FieldSpacecraftState newState = new FieldSpacecraftState(oldState.getOrbit().getType().normalize(newOrbit, oldState.getOrbit()), oldState.getAttitude(), newMass);
            for (FieldArrayDictionary.Entry entry : oldState.getAdditionalStatesValues().getData()) {
                newState = newState.addAdditionalState(entry.getKey(), entry.getValue());
            }
            for (FieldArrayDictionary.Entry entry : oldState.getAdditionalStatesDerivatives().getData()) {
                newState = newState.addAdditionalStateDerivative(entry.getKey(), entry.getValue());
            }
            return newState;
        }
    }
}

