/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;

public enum Control3DVectorCostType {
    NONE{

        @Override
        public double evaluate(Vector3D controlVector) {
            return 0.0;
        }

        @Override
        public <T extends CalculusFieldElement<T>> T evaluate(FieldVector3D<T> controlVector) {
            return (T)((CalculusFieldElement)controlVector.getX().getField().getZero());
        }
    }
    ,
    ONE_NORM{

        @Override
        public double evaluate(Vector3D controlVector) {
            return controlVector.getNorm1();
        }

        @Override
        public <T extends CalculusFieldElement<T>> T evaluate(FieldVector3D<T> controlVector) {
            return (T)controlVector.getNorm1();
        }
    }
    ,
    TWO_NORM{

        @Override
        public double evaluate(Vector3D controlVector) {
            return controlVector.getNorm();
        }

        @Override
        public <T extends CalculusFieldElement<T>> T evaluate(FieldVector3D<T> controlVector) {
            return (T)controlVector.getNorm();
        }
    }
    ,
    INF_NORM{

        @Override
        public double evaluate(Vector3D controlVector) {
            return controlVector.getNormInf();
        }

        @Override
        public <T extends CalculusFieldElement<T>> T evaluate(FieldVector3D<T> controlVector) {
            return (T)controlVector.getNormInf();
        }
    };


    public abstract double evaluate(Vector3D var1);

    public abstract <T extends CalculusFieldElement<T>> T evaluate(FieldVector3D<T> var1);
}

