/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.maneuvers.Control3DVectorCostType;
import org.orekit.forces.maneuvers.Maneuver;
import org.orekit.forces.maneuvers.propulsion.AbstractConstantThrustPropulsionModel;
import org.orekit.forces.maneuvers.propulsion.BasicConstantThrustPropulsionModel;
import org.orekit.forces.maneuvers.trigger.DateBasedManeuverTriggers;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;

public class ConstantThrustManeuver
extends Maneuver {
    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction) {
        this(date, duration, thrust, isp, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction, String name) {
        this(date, duration, thrust, isp, attitudeOverride, direction, Control3DVectorCostType.TWO_NORM, name);
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction) {
        this(date, duration, thrust, isp, attitudeOverride, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction, String name) {
        this(date, duration, thrust, isp, null, direction, name);
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction, Control3DVectorCostType control3DVectorCostType, String name) {
        this(date, duration, attitudeOverride, new BasicConstantThrustPropulsionModel(thrust, isp, direction, control3DVectorCostType, name));
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, AttitudeProvider attitudeOverride, AbstractConstantThrustPropulsionModel constantThrustPropulsionModel) {
        this(attitudeOverride, new DateBasedManeuverTriggers(constantThrustPropulsionModel.getName(), date, duration), constantThrustPropulsionModel);
    }

    public ConstantThrustManeuver(AttitudeProvider attitudeOverride, DateBasedManeuverTriggers dateBasedManeuverTriggers, AbstractConstantThrustPropulsionModel constantThrustPropulsionModel) {
        super(attitudeOverride, dateBasedManeuverTriggers, constantThrustPropulsionModel);
    }

    public Vector3D getThrustVector(AbsoluteDate date) {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getThrustVector(date);
    }

    public Vector3D getThrustVector() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getThrustVector();
    }

    public double getThrustMagnitude(AbsoluteDate date) {
        return this.getThrustVector(date).getNorm();
    }

    public double getThrustMagnitude() {
        return this.getThrustVector().getNorm();
    }

    public double getIsp(AbsoluteDate date) {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getIsp(date);
    }

    public double getIsp() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getIsp();
    }

    public double getFlowRate(AbsoluteDate date) {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getFlowRate(date);
    }

    public double getFlowRate() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getFlowRate();
    }

    public Vector3D getDirection(AbsoluteDate date) {
        return (Vector3D)this.getThrustVector(date).normalize();
    }

    public Vector3D getDirection() {
        return (Vector3D)this.getThrustVector().normalize();
    }

    public AbsoluteDate getStartDate() {
        return ((DateBasedManeuverTriggers)this.getManeuverTriggers()).getStartDate();
    }

    public AbsoluteDate getEndDate() {
        return ((DateBasedManeuverTriggers)this.getManeuverTriggers()).getEndDate();
    }

    public double getDuration() {
        return ((DateBasedManeuverTriggers)this.getManeuverTriggers()).getDuration();
    }

    public boolean isFiring(SpacecraftState s) {
        return this.isFiring(s.getDate());
    }

    public <T extends CalculusFieldElement<T>> boolean isFiring(FieldSpacecraftState<T> s) {
        return this.isFiring(s.getDate().toAbsoluteDate());
    }

    public boolean isFiring(AbsoluteDate date) {
        return this.getManeuverTriggers().isFiring(date, new double[0]);
    }
}

