/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.SinCos;

class TimeDependentHarmonic {
    private final int trendReferenceIndex;
    private final double cBase;
    private final double sBase;
    private double cTrend;
    private double sTrend;
    private int[] cosReferenceIndices;
    private int[] cosPulsationIndices;
    private double[] cosC;
    private double[] cosS;
    private int[] sinReferenceIndices;
    private int[] sinPulsationIndices;
    private double[] sinC;
    private double[] sinS;

    TimeDependentHarmonic(int trendReferenceIndex, double cBase, double sBase) {
        this(trendReferenceIndex, cBase, sBase, 0, 0);
    }

    TimeDependentHarmonic(double scale, TimeDependentHarmonic original) {
        this(original.trendReferenceIndex, scale * original.cBase, scale * original.sBase, original.cosReferenceIndices.length, original.sinReferenceIndices.length);
        int i;
        this.cTrend = scale * original.cTrend;
        this.sTrend = scale * original.sTrend;
        for (i = 0; i < this.cosReferenceIndices.length; ++i) {
            this.cosReferenceIndices[i] = original.cosReferenceIndices[i];
            this.cosPulsationIndices[i] = original.cosPulsationIndices[i];
            this.cosC[i] = scale * original.cosC[i];
            this.cosS[i] = scale * original.cosS[i];
        }
        for (i = 0; i < this.sinReferenceIndices.length; ++i) {
            this.sinReferenceIndices[i] = original.sinReferenceIndices[i];
            this.sinPulsationIndices[i] = original.sinPulsationIndices[i];
            this.sinC[i] = scale * original.sinC[i];
            this.sinS[i] = scale * original.sinS[i];
        }
    }

    private TimeDependentHarmonic(int trendReferenceIndex, double cBase, double sBase, int cSize, int sSize) {
        this.trendReferenceIndex = trendReferenceIndex;
        this.cBase = cBase;
        this.sBase = sBase;
        this.cTrend = 0.0;
        this.sTrend = 0.0;
        this.cosReferenceIndices = new int[cSize];
        this.cosPulsationIndices = new int[cSize];
        this.cosC = new double[cSize];
        this.cosS = new double[cSize];
        this.sinReferenceIndices = new int[sSize];
        this.sinPulsationIndices = new int[sSize];
        this.sinC = new double[sSize];
        this.sinS = new double[sSize];
    }

    public void setTrend(double cDot, double sDot) {
        this.cTrend = cDot;
        this.sTrend = sDot;
    }

    public void addCosine(int cosReferenceIndex, int cosPulsationIndex, double cosineC, double cosineS) {
        int refIndex = cosReferenceIndex < 0 ? this.trendReferenceIndex : cosReferenceIndex;
        this.cosReferenceIndices = TimeDependentHarmonic.addInt(refIndex, this.cosReferenceIndices);
        this.cosPulsationIndices = TimeDependentHarmonic.addInt(cosPulsationIndex, this.cosPulsationIndices);
        this.cosC = TimeDependentHarmonic.addDouble(cosineC, this.cosC);
        this.cosS = TimeDependentHarmonic.addDouble(cosineS, this.cosS);
    }

    public void addSine(int sinReferenceIndex, int sinPulsationIndex, double sineC, double sineS) {
        int refIndex = sinReferenceIndex < 0 ? this.trendReferenceIndex : sinReferenceIndex;
        this.sinReferenceIndices = TimeDependentHarmonic.addInt(refIndex, this.sinReferenceIndices);
        this.sinPulsationIndices = TimeDependentHarmonic.addInt(sinPulsationIndex, this.sinPulsationIndices);
        this.sinC = TimeDependentHarmonic.addDouble(sineC, this.sinC);
        this.sinS = TimeDependentHarmonic.addDouble(sineS, this.sinS);
    }

    private static int[] addInt(int n, int[] array) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = n;
        return newArray;
    }

    private static double[] addDouble(double d, double[] array) {
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = d;
        return newArray;
    }

    public double computeCnm(double[] offsets, SinCos[][] pulsations) {
        int i;
        double cnm = this.cBase + offsets[this.trendReferenceIndex] * this.cTrend;
        for (i = 0; i < this.cosPulsationIndices.length; ++i) {
            cnm += this.cosC[i] * pulsations[this.cosReferenceIndices[i]][this.cosPulsationIndices[i]].cos();
        }
        for (i = 0; i < this.sinPulsationIndices.length; ++i) {
            cnm += this.sinC[i] * pulsations[this.sinReferenceIndices[i]][this.sinPulsationIndices[i]].sin();
        }
        return cnm;
    }

    public double computeSnm(double[] offsets, SinCos[][] pulsations) {
        int i;
        double snm = this.sBase + offsets[this.trendReferenceIndex] * this.sTrend;
        for (i = 0; i < this.cosPulsationIndices.length; ++i) {
            snm += this.cosS[i] * pulsations[this.cosReferenceIndices[i]][this.cosPulsationIndices[i]].cos();
        }
        for (i = 0; i < this.sinPulsationIndices.length; ++i) {
            snm += this.sinS[i] * pulsations[this.sinReferenceIndices[i]][this.sinPulsationIndices[i]].sin();
        }
        return snm;
    }
}

